/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;

class Utils {
    private Utils() {
    }

    static JsonObject multiMapToJson(MultiMap headers) {
        JsonObject json = new JsonObject();
        for (String key : headers.names()) {
            json.put(key, (Object)headers.getAll(key));
        }
        return json;
    }

    static void putIfNotNull(JsonObject json, String key, Object value) {
        if (value != null) {
            json.put(key, value);
        }
    }

    static MultiMap jsonToMultiMap(JsonObject jsonHeaders) {
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        for (String key : jsonHeaders.getMap().keySet()) {
            headers.add(key, Utils.getKeyAsStringOrList(jsonHeaders, key));
        }
        return headers;
    }

    static List<String> getKeyAsStringOrList(JsonObject json, String key) {
        Object value = json.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Utils.asList((String)value);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).getList();
        }
        throw new IllegalArgumentException("invalid attachment type");
    }

    static <T> List<T> asList(T element) {
        return Collections.singletonList(element);
    }
}

