/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.auth.PRNG;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.Utils;
import io.vertx.ext.mail.impl.sasl.AuthCram;
import io.vertx.ext.mail.impl.sasl.AuthDigest;
import io.vertx.ext.mail.impl.sasl.AuthLogin;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthPlain;
import io.vertx.ext.mail.impl.sasl.AuthXOAUTH2;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AuthOperationFactory {
    private static final String[] ALGORITHMS = new String[]{"XOAUTH2", "DIGEST-MD5", "CRAM-SHA256", "CRAM-SHA1", "CRAM-MD5", "LOGIN", "PLAIN"};
    private final PRNG prng;
    private String authMethod;

    public AuthOperationFactory(PRNG prng) {
        this.prng = prng;
    }

    public List<String> supportedAuths(MailConfig config) {
        List<String> supported = Stream.of(ALGORITHMS).collect(Collectors.toList());
        String authMethods = config.getAuthMethods();
        if (authMethods != null && !authMethods.trim().isEmpty()) {
            supported.retainAll(Utils.parseCapaAuth(authMethods));
        }
        return supported;
    }

    public synchronized String getAuthMethod() {
        return this.authMethod;
    }

    public synchronized AuthOperationFactory setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    public AuthOperation createAuth(String username, String password, String authMethod) {
        switch (authMethod) {
            case "XOAUTH2": {
                return new AuthXOAUTH2(username, password);
            }
            case "CRAM-MD5": {
                return new AuthCram("CRAM-MD5", username, password);
            }
            case "CRAM-SHA1": {
                return new AuthCram("CRAM-SHA1", username, password);
            }
            case "CRAM-SHA256": {
                return new AuthCram("CRAM-SHA256", username, password);
            }
            case "DIGEST-MD5": {
                return new AuthDigest("DIGEST-MD5", this.prng, username, password);
            }
            case "LOGIN": {
                return new AuthLogin(username, password);
            }
            case "PLAIN": {
                return new AuthPlain(username, password);
            }
        }
        throw new IllegalArgumentException("Unsupported Authentication Method: " + authMethod);
    }
}

