/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import io.vertx.ext.mail.impl.sasl.CryptUtils;
import java.util.List;

class SMTPAuthentication {
    private final SMTPConnection connection;
    private final MailConfig config;
    private final Handler<Void> finishedHandler;
    private final Handler<Throwable> errorHandler;
    private static final Logger log = LoggerFactory.getLogger(SMTPAuthentication.class);
    private final AuthOperationFactory authOperationFactory;

    SMTPAuthentication(SMTPConnection connection, MailConfig config, AuthOperationFactory authOperationFactory, Handler<Void> finishedHandler, Handler<Throwable> errorHandler) {
        this.connection = connection;
        this.config = config;
        this.finishedHandler = finishedHandler;
        this.errorHandler = errorHandler;
        this.authOperationFactory = authOperationFactory;
    }

    public void start() {
        boolean foundAllowedMethods;
        List<String> auths = this.intersectAllowedMethods();
        boolean bl = foundAllowedMethods = !auths.isEmpty();
        if (this.config.getLogin() != LoginOption.DISABLED && this.config.getUsername() != null && this.config.getPassword() != null && foundAllowedMethods) {
            this.authCmd(auths);
        } else if (this.config.getLogin() == LoginOption.REQUIRED) {
            if (!foundAllowedMethods) {
                this.handleError("login is required, but no allowed AUTH methods available. You may need to do STARTTLS");
            } else {
                this.handleError("login is required, but no credentials supplied");
            }
        } else {
            this.finished();
        }
    }

    private List<String> intersectAllowedMethods() {
        List<String> supported = this.authOperationFactory.supportedAuths(this.config);
        supported.retainAll(this.connection.getCapa().getCapaAuth());
        return supported;
    }

    private void authCmd(List<String> auths) {
        String defaultAuth = this.authOperationFactory.getAuthMethod();
        if (defaultAuth != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default auth method: " + defaultAuth));
            }
            this.authMethod(defaultAuth, (Handler<Void>)((Handler)error -> this.authChain(auths, 0)));
        } else {
            this.authChain(auths, 0);
        }
    }

    private void authChain(List<String> auths, int i) {
        if (i < auths.size()) {
            this.authMethod(auths.get(i), (Handler<Void>)((Handler)error -> this.authChain(auths, i + 1)));
        } else {
            this.handleError("Failed to authenticate");
        }
    }

    private void authMethod(String auth, Handler<Void> onError) {
        AuthOperation authMethod;
        try {
            authMethod = this.authOperationFactory.createAuth(this.config, auth);
        }
        catch (IllegalArgumentException | SecurityException ex) {
            log.warn((Object)"authentication factory threw exception", (Throwable)ex);
            this.handleError(ex);
            return;
        }
        this.authCmdStep(authMethod, null, onError);
    }

    private void authCmdStep(AuthOperation authMethod, String message, Handler<Void> onError) {
        int blank;
        String nextLine;
        try {
            if (message == null) {
                String authParameter = authMethod.nextStep(null);
                if (!authParameter.isEmpty()) {
                    if (!authMethod.handleCoding()) {
                        authParameter = CryptUtils.base64(authParameter);
                    }
                    nextLine = "AUTH " + authMethod.getName() + " " + authParameter;
                    blank = authMethod.getName().length() + 6;
                } else {
                    nextLine = "AUTH " + authMethod.getName();
                    blank = -1;
                }
            } else {
                nextLine = !authMethod.handleCoding() ? CryptUtils.base64(authMethod.nextStep(CryptUtils.decodeb64(message.substring(4)))) : authMethod.nextStep(message.substring(4));
                blank = 0;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to handle server auth message: " + message), (Throwable)e);
            onError.handle(null);
            return;
        }
        this.connection.write(nextLine, blank, (Handler<String>)((Handler)message2 -> {
            if (StatusCode.isStatusOk(message2)) {
                if (StatusCode.isStatusContinue(message2)) {
                    log.debug((Object)("Auth Continue with response: " + message2));
                    this.authCmdStep(authMethod, (String)message2, onError);
                } else {
                    this.authOperationFactory.setAuthMethod(authMethod.getName());
                    this.finished();
                }
            } else {
                log.warn((Object)("AUTH " + authMethod.getName() + " failed " + message2));
                onError.handle(null);
            }
        }));
    }

    private void finished() {
        this.finishedHandler.handle(null);
    }

    private void handleError(String message) {
        this.errorHandler.handle((Object)new NoStackTraceThrowable(message));
    }

    private void handleError(Throwable th) {
        this.errorHandler.handle((Object)th);
    }
}

