/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.Capabilities;
import io.vertx.ext.mail.impl.MultilineParser;
import java.io.IOException;
import java.util.List;

class SMTPConnection {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnection.class);
    private final NetSocket ns;
    private final MailConfig config;
    private Lease<SMTPConnection> lease;
    private MultilineParser nsHandler;
    private final Handler<Void> evictionHandler;
    private boolean evicted;
    private boolean socketClosed;
    private boolean shutdown;
    private boolean closing;
    private boolean inuse;
    private boolean quitSent;
    private Handler<String> commandReplyHandler;
    private Handler<Throwable> errorHandler;
    private Handler<AsyncResult<Void>> closeHandler;
    private Capabilities capa = new Capabilities();
    private final ContextInternal context;
    private long expirationTimestamp;

    SMTPConnection(MailConfig config, NetSocket ns, ContextInternal context, Handler<Void> evictionHandler) {
        this.config = config;
        this.ns = ns;
        this.context = context;
        this.evictionHandler = evictionHandler;
    }

    private static long expirationTimestampOf(MailConfig config) {
        long timeout = config.getKeepAliveTimeout();
        return timeout == 0L ? 0L : System.currentTimeMillis() + config.getKeepAliveTimeoutUnit().toMillis(timeout);
    }

    SMTPConnection setLease(Lease<SMTPConnection> lease) {
        this.lease = lease;
        return this;
    }

    boolean isInitialized() {
        return this.nsHandler != null;
    }

    void init(Handler<String> initialReplyHandler) {
        if (this.nsHandler != null) {
            throw new IllegalStateException("SMTPConnection has been initialized.");
        }
        this.nsHandler = new MultilineParser((Handler<Buffer>)((Handler)buffer -> {
            if (this.commandReplyHandler == null && !this.quitSent) {
                this.handleError(new IllegalStateException("dropping reply arriving after we stopped processing the buffer."));
            } else {
                Handler<String> currentHandler = this.commandReplyHandler;
                this.commandReplyHandler = null;
                if (currentHandler != null) {
                    this.context.emit((Object)buffer.toString(), currentHandler);
                }
            }
        }));
        this.ns.exceptionHandler(this::handleNSException);
        this.ns.closeHandler(this::handleNSClosed);
        this.commandReplyHandler = initialReplyHandler;
        this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
        this.ns.handler((Handler)this.nsHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNSException(Throwable t) {
        if (!this.socketClosed && !this.shutdown) {
            Handler<Throwable> handler;
            SMTPConnection sMTPConnection = this;
            synchronized (sMTPConnection) {
                handler = this.errorHandler;
            }
            this.shutdown();
            if (this.quitSent) {
                log.debug((Object)"got an exception on the netsocket after quit sent", t);
            } else {
                this.handleError(t, handler);
            }
        } else {
            log.debug((Object)"not returning follow-up exception", t);
        }
    }

    boolean isAvailable() {
        return !this.socketClosed && !this.shutdown;
    }

    boolean isValid() {
        return (this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp) && !this.quitSent;
    }

    void handleNSClosed(Void v) {
        log.trace((Object)"handleNSClosed() - socket has been closed");
        this.socketClosed = true;
        if (!this.shutdown && !this.quitSent) {
            this.handleError(new IOException("socket was closed unexpected."));
            this.shutdown();
        }
        this.handleClosed();
    }

    private void handleClosed() {
        if (this.closeHandler != null) {
            this.closeHandler.handle((Object)Future.succeededFuture());
            this.closeHandler = null;
        }
        if (!this.evicted) {
            this.evicted = true;
            this.evictionHandler.handle(null);
            this.cleanHandlers();
        }
    }

    Capabilities getCapa() {
        return this.capa;
    }

    void parseCapabilities(String message) {
        this.capa = new Capabilities();
        this.capa.parseCapabilities(message);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Supported Auth methods: ");
            this.capa.getCapaAuth().forEach(a -> sb.append((String)a).append(" "));
            sb.append("\n");
            if (this.capa.getSize() > 0) {
                sb.append("Max Size: ").append(this.capa.getSize()).append("\n");
            }
            sb.append("Support STARTTLS: ").append(this.capa.isStartTLS()).append(", Current connection TLS: ").append(this.isSsl()).append("\n");
            sb.append("Support PIPELINING: ").append(this.capa.isCapaPipelining()).append("\n");
            log.debug((Object)sb);
        }
    }

    void shutdown() {
        this.shutdown = true;
        if (!this.socketClosed) {
            this.socketClosed = true;
            this.ns.close();
        }
        this.handleClosed();
    }

    private void cleanHandlers() {
        this.errorHandler = null;
        this.commandReplyHandler = null;
    }

    void writeCommands(List<String> commands, Handler<String> resultHandler) {
        String cmds = String.join((CharSequence)"\r\n", commands);
        this.nsHandler.setExpected(commands.size());
        this.write(cmds, (Handler<String>)((Handler)r -> {
            try {
                resultHandler.handle(r);
            }
            finally {
                this.nsHandler.setExpected(1);
            }
        }));
    }

    void write(String str, Handler<String> commandResultHandler) {
        this.write(str, -1, commandResultHandler);
    }

    void write(String str, int blank, Handler<String> commandResultHandler) {
        this.commandReplyHandler = commandResultHandler;
        this.checkClosed();
        this.context.emit(roc -> {
            if (log.isDebugEnabled()) {
                String logStr;
                if (blank >= 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = blank; i < str.length(); ++i) {
                        sb.append('*');
                    }
                    logStr = str.substring(0, blank) + sb;
                } else {
                    logStr = str;
                }
                if (logStr.length() < 1000) {
                    log.debug((Object)("command: " + logStr));
                } else {
                    log.debug((Object)("command: " + logStr.substring(0, 1000) + "..."));
                }
            }
            this.ns.write(str + "\r\n", r -> {
                if (r.failed()) {
                    this.handleNSException(r.cause());
                }
            });
        });
    }

    void writeLineWithDrainPromise(String str, boolean mayLog, Promise<Void> promise) {
        if (this.checkClosed()) {
            promise.fail("Connection was closed");
            return;
        }
        if (mayLog) {
            log.debug((Object)str);
        }
        this.context.emit(roc -> {
            if (this.ns.writeQueueFull()) {
                this.ns.drainHandler(v -> {
                    this.ns.drainHandler(null);
                    this.ns.write(str + "\r\n").onComplete((Handler)promise);
                });
            } else {
                this.ns.write(str + "\r\n").onComplete((Handler)promise);
            }
        });
    }

    private void handleError(Throwable t) {
        this.context.emit((Object)t, err -> {
            Handler<Throwable> handler;
            SMTPConnection sMTPConnection = this;
            synchronized (sMTPConnection) {
                handler = this.errorHandler;
            }
            if (handler != null) {
                handler.handle(err);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)t.getMessage(), t);
            }
        });
    }

    private void handleError(Throwable t, Handler<Throwable> handler) {
        this.context.emit((Object)t, err -> {
            if (handler != null) {
                handler.handle(err);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)t.getMessage(), t);
            }
        });
    }

    boolean isSsl() {
        return this.ns.isSsl();
    }

    void upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        this.ns.upgradeToSsl(handler);
    }

    Future<SMTPConnection> returnToPool() {
        log.trace((Object)"return to pool");
        PromiseInternal promise = this.context.promise();
        try {
            if (this.config.isKeepAlive() && !this.closing) {
                log.trace((Object)"recycle for next use");
                this.cleanHandlers();
                this.lease.recycle();
                this.inuse = false;
                this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
                promise.complete((Object)this);
            } else {
                Promise p = Promise.promise();
                p.future().onComplete(arg_0 -> this.lambda$returnToPool$9((Promise)promise, arg_0));
                this.quitCloseConnection((Promise<Void>)p);
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    void quitCloseConnection(Promise<Void> promise) {
        this.quitSent = true;
        this.inuse = false;
        log.trace((Object)"send QUIT to close");
        this.writeLineWithDrainPromise("QUIT", false, promise);
    }

    private boolean checkClosed() {
        if (this.isClosed() || this.shutdown) {
            this.handleError((Throwable)new NoStackTraceThrowable("Connection was closed."));
            return true;
        }
        return false;
    }

    void setErrorHandler(Handler<Throwable> newHandler) {
        this.errorHandler = newHandler;
    }

    void setInUse() {
        this.inuse = true;
        this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
    }

    void close(Promise<Void> promise) {
        this.closing = true;
        if (!this.inuse) {
            log.trace((Object)"close by sending quit in close()");
            this.quitCloseConnection(promise);
        } else {
            this.closeHandler = promise;
            if (this.quitSent) {
                this.shutdown();
            }
        }
    }

    boolean isClosed() {
        return this.socketClosed;
    }

    Context getContext() {
        return this.context;
    }

    NetSocket getSocket() {
        return this.ns;
    }

    private /* synthetic */ void lambda$returnToPool$9(Promise promise, AsyncResult conn) {
        this.handleClosed();
        promise.complete((Object)this);
    }
}

