/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;

class SMTPReset {
    private final SMTPConnection connection;
    private final Handler<AsyncResult<SMTPConnection>> handler;

    SMTPReset(SMTPConnection connection, Handler<AsyncResult<SMTPConnection>> finishedHandler) {
        this.connection = connection;
        this.handler = finishedHandler;
    }

    void start() {
        this.connection.setErrorHandler((Handler<Throwable>)((Handler)th -> this.handler.handle((Object)Future.failedFuture((Throwable)th))));
        this.connection.write("RSET", (Handler<String>)((Handler)message -> {
            SMTPResponse response = new SMTPResponse((String)message);
            if (!response.isStatusOk()) {
                this.handler.handle((Object)Future.failedFuture((Throwable)((Object)response.toException("reset command failed"))));
            } else {
                this.handler.handle((Object)Future.succeededFuture((Object)this.connection));
            }
        }));
    }
}

