/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.MailClientBuilder;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.MailClientBuilderImpl;

@VertxGen
public interface MailClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public static MailClientBuilder builder(Vertx vertx) {
        return new MailClientBuilderImpl(vertx);
    }

    public static MailClient create(Vertx vertx, MailConfig config) {
        return MailClient.builder(vertx).with(config).build();
    }

    public static MailClient createShared(Vertx vertx, MailConfig config, String poolName) {
        return MailClient.builder(vertx).with(config).shared(poolName).build();
    }

    public static MailClient createShared(Vertx vertx, MailConfig config) {
        return MailClient.builder(vertx).with(config).shared(DEFAULT_POOL_NAME).build();
    }

    @Fluent
    public MailClient sendMail(MailMessage var1, Handler<AsyncResult<MailResult>> var2);

    default public Future<MailResult> sendMail(MailMessage email) {
        Promise promise = Promise.promise();
        this.sendMail(email, (Handler<AsyncResult<MailResult>>)promise);
        return promise.future();
    }

    default public Future<Void> close() {
        Promise promise = Promise.promise();
        this.close((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    public void close(Handler<AsyncResult<Void>> var1);
}

