/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPAuthentication;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPInitialDialogue;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import java.util.function.Supplier;

class SMTPStarter {
    private static final Expectation<UsernamePasswordCredentials> CREDENTIALS_EXPECTATION = new Expectation<UsernamePasswordCredentials>(){

        public boolean test(UsernamePasswordCredentials credentials) {
            return credentials != null && credentials.getUsername() != null && credentials.getPassword() != null;
        }

        public Throwable describe(UsernamePasswordCredentials credentials) {
            if (credentials == null) {
                return new VertxException("Credentials must not be null", true);
            }
            return new VertxException("Username or password is null", true);
        }
    };
    private final SMTPConnection connection;
    private final String hostname;
    private final MailConfig config;
    private final AuthOperationFactory authOperationFactory;
    private final Supplier<Future<UsernamePasswordCredentials>> credentialsSupplier;
    private final Handler<AsyncResult<SMTPConnection>> handler;

    SMTPStarter(SMTPConnection connection, MailConfig config, String hostname, AuthOperationFactory authOperationFactory, Supplier<Future<UsernamePasswordCredentials>> credentialsSupplier, Handler<AsyncResult<SMTPConnection>> handler) {
        this.connection = connection;
        this.hostname = hostname;
        this.config = config;
        this.authOperationFactory = authOperationFactory;
        this.credentialsSupplier = credentialsSupplier;
        this.handler = handler;
    }

    void serverGreeting(String message) {
        Future creds = this.credentialsSupplier != null ? this.credentialsSupplier.get().expecting(CREDENTIALS_EXPECTATION) : Future.succeededFuture();
        creds.onComplete(credentials -> new SMTPInitialDialogue(this.connection, this.config, this.hostname, (Handler<Void>)((Handler)v -> this.doAuthentication((UsernamePasswordCredentials)credentials)), (Handler<Throwable>)((Handler)this::handleError)).start(message), this::handleError);
    }

    private void doAuthentication(UsernamePasswordCredentials credentials) {
        new SMTPAuthentication(this.connection, this.config, this.authOperationFactory, (Handler<Void>)((Handler)v -> this.handler.handle((Object)Future.succeededFuture((Object)this.connection))), (Handler<Throwable>)((Handler)this::handleError), credentials).start();
    }

    private void handleError(Throwable throwable) {
        this.handler.handle((Object)Future.failedFuture((Throwable)throwable));
    }
}

