/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPEndPoint;
import io.vertx.ext.mail.impl.SMTPReset;
import io.vertx.ext.mail.impl.SMTPStarter;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

class SMTPConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnectionPool.class);
    private static final int RSET_MAX_RETRY = Integer.getInteger("vertx.mail.rset.max.retry", 5);
    private final PRNG prng;
    private final AuthOperationFactory authOperationFactory;
    private final Vertx vertx;
    private final NetClient netClient;
    private final MailConfig config;
    private boolean closed = false;
    private final AtomicReference<SMTPEndPoint> endPoint = new AtomicReference();
    private long timerID = -1L;

    SMTPConnectionPool(Vertx vertx, MailConfig config) {
        this.vertx = vertx;
        this.config = config;
        String verification = config.getHostnameVerificationAlgorithm();
        if (!(verification != null && !verification.isEmpty() || config.isTrustAll() || !config.isSsl() && config.getStarttls() == StartTLSOptions.DISABLED)) {
            config.setHostnameVerificationAlgorithm("HTTPS");
        } else {
            config.setHostnameVerificationAlgorithm("");
        }
        this.netClient = vertx.createNetClient((NetClientOptions)config);
        this.prng = new PRNG(vertx);
        this.authOperationFactory = new AuthOperationFactory(this.prng);
        if (config.getPoolCleanerPeriod() > 0 && config.isKeepAlive() && config.getKeepAliveTimeout() > 0) {
            this.timerID = vertx.setTimer(SMTPConnectionPool.poolCleanTimeout(config), this::checkExpired);
        }
    }

    private static long poolCleanTimeout(MailConfig config) {
        return config.getPoolCleanerPeriodUnit().toMillis(config.getPoolCleanerPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired(long timer) {
        this.getSMTPEndPoint().checkExpired((Handler<AsyncResult<List<SMTPConnection>>>)((Handler)ar -> {
            if (ar.succeeded()) {
                ((List)ar.result()).forEach(c -> c.quitCloseConnection((Promise<Void>)Promise.promise()));
            }
        }));
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (!this.closed) {
                this.timerID = this.vertx.setTimer(SMTPConnectionPool.poolCleanTimeout(this.config), this::checkExpired);
            }
        }
    }

    AuthOperationFactory getAuthOperationFactory() {
        return this.authOperationFactory;
    }

    void getConnection(String hostname, Handler<AsyncResult<SMTPConnection>> resultHandler) {
        this.getConnection(hostname, this.vertx.getOrCreateContext(), resultHandler);
    }

    void getConnection(String hostname, Context ctx, Handler<AsyncResult<SMTPConnection>> resultHandler) {
        this.getConnection0(hostname, ctx, resultHandler, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnection0(String hostname, Context ctx, Handler<AsyncResult<SMTPConnection>> resultHandler, int i) {
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (this.closed) {
                resultHandler.handle((Object)Future.failedFuture((String)"connection pool is closed"));
                return;
            }
        }
        ContextInternal contextInternal = (ContextInternal)ctx;
        PromiseInternal promise = contextInternal.promise();
        promise.future().map(l -> ((SMTPConnection)l.get()).setLease((Lease<SMTPConnection>)l)).flatMap(conn -> {
            Future future;
            boolean reset;
            conn.setInUse();
            if (conn.isInitialized()) {
                reset = true;
                PromiseInternal connReset = contextInternal.promise();
                new SMTPReset((SMTPConnection)conn, (Handler<AsyncResult<SMTPConnection>>)connReset).start();
                future = connReset.future();
            } else {
                reset = false;
                PromiseInternal connInitial = contextInternal.promise();
                SMTPStarter starter = new SMTPStarter((SMTPConnection)conn, this.config, hostname, this.authOperationFactory, (Handler<AsyncResult<SMTPConnection>>)connInitial);
                try {
                    conn.init((Handler<String>)((Handler)starter::serverGreeting));
                }
                catch (Exception e) {
                    connInitial.handle((AsyncResult)Future.failedFuture((Throwable)e));
                }
                future = connInitial.future();
            }
            return future.recover(t -> {
                PromiseInternal quitPromise = contextInternal.promise();
                if (t instanceof IOException) {
                    conn.shutdown();
                    quitPromise.fail(t);
                } else {
                    conn.quitCloseConnection((Promise<Void>)quitPromise);
                }
                return quitPromise.future().transform(v -> {
                    if (reset && i < RSET_MAX_RETRY) {
                        PromiseInternal getConnAgain = contextInternal.promise();
                        log.debug((Object)("Failed on RSET, try " + (i + 1) + " time"));
                        this.getConnection0(hostname, ctx, (Handler<AsyncResult<SMTPConnection>>)getConnAgain, i + 1);
                        return getConnAgain.future();
                    }
                    conn.shutdown();
                    return Future.failedFuture((Throwable)t);
                });
            });
        }).onComplete(resultHandler);
        this.getSMTPEndPoint().getConnection(contextInternal, this.config.getConnectTimeout(), (Handler)promise);
    }

    private SMTPEndPoint getSMTPEndPoint() {
        return this.endPoint.accumulateAndGet(this.endPoint.get(), (p, n) -> p == null ? new SMTPEndPoint(this.netClient, this.config, () -> this.endPoint.set(null)) : p);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)h -> {
            if (h.failed()) {
                log.warn((Object)"Failed to close the pool", h.cause());
            }
            log.debug((Object)"SMTP connection pool closed.");
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Handler<AsyncResult<Void>> finishedHandler) {
        log.debug((Object)"trying to close the connection pool");
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (this.closed) {
                throw new IllegalStateException("pool is already closed");
            }
            this.closed = true;
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.prng.close();
        Promise closePromise = Promise.promise();
        closePromise.future().flatMap(list -> {
            List futures = list.stream().filter(connFuture -> connFuture.succeeded() && ((SMTPConnection)connFuture.result()).isAvailable()).map(connFuture -> {
                Promise promise = Promise.promise();
                ((SMTPConnection)connFuture.result()).close((Promise<Void>)promise);
                return promise.future();
            }).collect(Collectors.toList());
            return CompositeFuture.all(futures);
        }).flatMap(f -> this.netClient.close()).onComplete(r -> {
            log.debug((Object)"Close net client");
            if (r.succeeded()) {
                if (finishedHandler != null) {
                    finishedHandler.handle((Object)Future.succeededFuture());
                }
            } else if (finishedHandler != null) {
                finishedHandler.handle((Object)Future.failedFuture((Throwable)r.cause()));
            }
        });
        this.getSMTPEndPoint().close((Promise<List<Future<SMTPConnection>>>)closePromise);
    }

    int connCount() {
        return this.getSMTPEndPoint().size();
    }

    NetClient getNetClient() {
        return this.netClient;
    }
}

