/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Utils {
    private Utils() {
    }

    public static Set<String> parseCapaAuth(String auths) {
        return new HashSet<String>(Utils.splitByChar(auths, ' '));
    }

    static List<String> splitByChar(String message, char ch) {
        int nextIndex;
        ArrayList<String> lines = new ArrayList<String>();
        int index = 0;
        while ((nextIndex = message.indexOf(ch, index)) != -1) {
            lines.add(message.substring(index, nextIndex));
            index = nextIndex + 1;
        }
        lines.add(message.substring(index));
        return lines;
    }

    public static String getHostname() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            return ip.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static JsonObject multiMapToJson(MultiMap headers) {
        JsonObject json = new JsonObject();
        for (String key : headers.names()) {
            json.put(key, (Object)headers.getAll(key));
        }
        return json;
    }

    public static void putIfNotNull(JsonObject json, String key, Object value) {
        if (value != null) {
            json.put(key, value);
        }
    }

    public static MultiMap jsonToMultiMap(JsonObject jsonHeaders) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        for (String key : jsonHeaders.getMap().keySet()) {
            headers.add(key, Utils.getKeyAsStringOrList(jsonHeaders, key));
        }
        return headers;
    }

    public static List<String> getKeyAsStringOrList(JsonObject json, String key) {
        Object value = json.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Utils.asList((String)value);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).getList();
        }
        throw new IllegalArgumentException("invalid attachment type");
    }

    public static <T> List<T> asList(T element) {
        return Collections.singletonList(element);
    }
}

