/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.CanonicalizationAlgorithm;
import io.vertx.ext.mail.DKIMSignAlgorithm;
import io.vertx.ext.mail.DKIMSignOptions;
import java.util.ArrayList;
import java.util.Map;

public class DKIMSignOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, DKIMSignOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "signAlgo": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSignAlgo(DKIMSignAlgorithm.valueOf((String)member.getValue()));
                    break;
                }
                case "privateKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPrivateKey((String)member.getValue());
                    break;
                }
                case "privateKeyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPrivateKeyPath((String)member.getValue());
                    break;
                }
                case "signedHeaders": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSignedHeaders(list);
                    break;
                }
                case "sdid": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSdid((String)member.getValue());
                    break;
                }
                case "selector": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSelector((String)member.getValue());
                    break;
                }
                case "headerCanonAlgo": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHeaderCanonAlgo(CanonicalizationAlgorithm.valueOf((String)member.getValue()));
                    break;
                }
                case "bodyCanonAlgo": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBodyCanonAlgo(CanonicalizationAlgorithm.valueOf((String)member.getValue()));
                    break;
                }
                case "auid": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuid((String)member.getValue());
                    break;
                }
                case "bodyLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBodyLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "signatureTimestamp": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSignatureTimestamp((Boolean)member.getValue());
                    break;
                }
                case "expireTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setExpireTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "copiedHeaders": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setCopiedHeaders(list);
                }
            }
        }
    }

    static void toJson(DKIMSignOptions obj, JsonObject json) {
        DKIMSignOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(DKIMSignOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getSignAlgo() != null) {
            json.put("signAlgo", obj.getSignAlgo().name());
        }
        if (obj.getPrivateKey() != null) {
            json.put("privateKey", obj.getPrivateKey());
        }
        if (obj.getPrivateKeyPath() != null) {
            json.put("privateKeyPath", obj.getPrivateKeyPath());
        }
        if (obj.getSignedHeaders() != null) {
            array = new JsonArray();
            obj.getSignedHeaders().forEach(item -> array.add(item));
            json.put("signedHeaders", array);
        }
        if (obj.getSdid() != null) {
            json.put("sdid", obj.getSdid());
        }
        if (obj.getSelector() != null) {
            json.put("selector", obj.getSelector());
        }
        if (obj.getHeaderCanonAlgo() != null) {
            json.put("headerCanonAlgo", obj.getHeaderCanonAlgo().name());
        }
        if (obj.getBodyCanonAlgo() != null) {
            json.put("bodyCanonAlgo", obj.getBodyCanonAlgo().name());
        }
        if (obj.getAuid() != null) {
            json.put("auid", obj.getAuid());
        }
        json.put("bodyLimit", obj.getBodyLimit());
        json.put("signatureTimestamp", obj.isSignatureTimestamp());
        json.put("expireTime", obj.getExpireTime());
        if (obj.getCopiedHeaders() != null) {
            array = new JsonArray();
            obj.getCopiedHeaders().forEach(item -> array.add(item));
            json.put("copiedHeaders", array);
        }
    }
}

