/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.impl.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MailAttachmentImpl
implements MailAttachment {
    private ReadStream<Buffer> stream;
    private int size = -1;
    private Buffer data;
    private String name;
    private String contentType;
    private String disposition;
    private String description;
    private String contentId;
    private MultiMap headers;

    public MailAttachmentImpl() {
    }

    public MailAttachmentImpl(MailAttachment otherMailAttachment) {
        Objects.requireNonNull(otherMailAttachment);
        MailAttachmentImpl other = (MailAttachmentImpl)otherMailAttachment;
        this.data = other.data == null ? null : other.data.copy();
        this.name = other.name;
        this.contentType = other.contentType;
        this.disposition = other.disposition;
        this.description = other.description;
        this.contentId = other.contentId;
        this.headers = other.headers == null ? null : MultiMap.caseInsensitiveMultiMap().addAll(other.headers);
        this.size = other.size;
        this.stream = other.stream;
    }

    public MailAttachmentImpl(JsonObject json) {
        Objects.requireNonNull(json);
        this.data = json.getBinary("data") == null ? null : Buffer.buffer((byte[])json.getBinary("data"));
        this.name = json.getString("name");
        this.contentType = json.getString("contentType");
        this.disposition = json.getString("disposition");
        this.description = json.getString("description");
        this.contentId = json.getString("contentId");
        JsonObject headers = json.getJsonObject("headers");
        if (headers != null) {
            this.headers = Utils.jsonToMultiMap(headers);
        }
        this.size = json.getInteger("size", Integer.valueOf(-1));
    }

    @Override
    public ReadStream<Buffer> getStream() {
        return this.stream;
    }

    @Override
    public MailAttachment setStream(ReadStream<Buffer> stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public MailAttachment setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size of the Attachment cannot be smaller than 0");
        }
        this.size = size;
        return this;
    }

    @Override
    public Buffer getData() {
        return this.data;
    }

    @Override
    public MailAttachment setData(Buffer data) {
        this.data = data;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MailAttachment setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public MailAttachment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    @Override
    public MailAttachment setDisposition(String disposition) {
        this.disposition = disposition;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MailAttachment setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public MailAttachment setContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    @Override
    public MailAttachment addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @Override
    public MultiMap getHeaders() {
        return this.headers;
    }

    @Override
    public MailAttachment setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.data != null) {
            json.put("data", (Object)this.data.getBytes());
        }
        Utils.putIfNotNull(json, "name", this.name);
        Utils.putIfNotNull(json, "contentType", this.contentType);
        Utils.putIfNotNull(json, "disposition", this.disposition);
        Utils.putIfNotNull(json, "description", this.description);
        Utils.putIfNotNull(json, "contentId", this.contentId);
        if (this.headers != null) {
            json.put("headers", (Object)Utils.multiMapToJson(this.headers));
        }
        if (this.size >= 0) {
            json.put("size", (Object)this.size);
        }
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(this.data, this.name, this.disposition, this.description, this.contentId, this.headers, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailAttachmentImpl)) {
            return false;
        }
        MailAttachmentImpl attachment = (MailAttachmentImpl)o;
        return this.getList().equals(attachment.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }
}

