/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import io.vertx.ext.mail.impl.sasl.CryptUtils;
import java.util.List;

class SMTPAuthentication {
    private static final Logger log = LoggerFactory.getLogger(SMTPAuthentication.class);
    private final SMTPConnection connection;
    private final MailConfig config;
    private final AuthOperationFactory authOperationFactory;
    private final Promise<Void> promise;

    SMTPAuthentication(ContextInternal context, SMTPConnection connection, MailConfig config, AuthOperationFactory authOperationFactory) {
        this.connection = connection;
        this.config = config;
        this.authOperationFactory = authOperationFactory;
        this.promise = context.promise();
    }

    public Future<Void> start() {
        boolean foundAllowedMethods;
        List<String> auths = this.intersectAllowedMethods();
        boolean bl = foundAllowedMethods = !auths.isEmpty();
        if (this.config.getLogin() != LoginOption.DISABLED && this.config.getUsername() != null && this.config.getPassword() != null && foundAllowedMethods) {
            this.authCmd(auths);
        } else if (this.config.getLogin() == LoginOption.REQUIRED) {
            if (!foundAllowedMethods) {
                this.promise.fail("login is required, but no allowed AUTH methods available. You may need to do STARTTLS");
            } else {
                this.promise.fail("login is required, but no credentials supplied");
            }
        } else {
            this.promise.complete();
        }
        return this.promise.future();
    }

    private List<String> intersectAllowedMethods() {
        List<String> supported = this.authOperationFactory.supportedAuths(this.config);
        supported.retainAll(this.connection.getCapa().getCapaAuth());
        return supported;
    }

    private void authCmd(List<String> auths) {
        String defaultAuth = this.authOperationFactory.getAuthMethod();
        if (defaultAuth != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default auth method: " + defaultAuth));
            }
            this.authMethod(defaultAuth, (Handler<Throwable>)((Handler)error -> this.authChain(auths, 0, null)));
        } else {
            this.authChain(auths, 0, null);
        }
    }

    private void authChain(List<String> auths, int i, Throwable e) {
        if (i < auths.size()) {
            if (e != null) {
                log.warn((Object)e);
            }
            this.authMethod(auths.get(i), (Handler<Throwable>)((Handler)error -> this.authChain(auths, i + 1, (Throwable)error)));
        } else {
            this.promise.fail(e);
        }
    }

    private void authMethod(String auth, Handler<Throwable> onError) {
        AuthOperation authMethod;
        try {
            authMethod = this.authOperationFactory.createAuth(this.config, auth);
        }
        catch (IllegalArgumentException | SecurityException ex) {
            log.warn((Object)"authentication factory threw exception", (Throwable)ex);
            this.promise.fail((Throwable)ex);
            return;
        }
        this.authCmdStep(authMethod, null, onError);
    }

    private void authCmdStep(AuthOperation authMethod, String message, Handler<Throwable> onError) {
        int blank;
        Object nextLine;
        try {
            if (message == null) {
                String authParameter = authMethod.nextStep(null);
                if (!authParameter.isEmpty()) {
                    if (!authMethod.handleCoding()) {
                        authParameter = CryptUtils.base64(authParameter);
                    }
                    nextLine = "AUTH " + authMethod.getName() + " " + authParameter;
                    blank = authMethod.getName().length() + 6;
                } else {
                    nextLine = "AUTH " + authMethod.getName();
                    blank = -1;
                }
            } else {
                nextLine = !authMethod.handleCoding() ? CryptUtils.base64(authMethod.nextStep(CryptUtils.decodeb64(message.substring(4)))) : authMethod.nextStep(message.substring(4));
                blank = 0;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to handle server auth message: " + message), (Throwable)e);
            onError.handle((Object)e);
            return;
        }
        this.connection.write((String)nextLine, blank).onComplete(ar -> {
            if (ar.failed()) {
                onError.handle((Object)ar.cause());
                return;
            }
            SMTPResponse response = (SMTPResponse)ar.result();
            if (response.isStatusOk()) {
                if (response.isStatusContinue()) {
                    log.debug((Object)("Auth Continue with response: " + response.getValue()));
                    this.authCmdStep(authMethod, response.getValue(), onError);
                } else {
                    this.authOperationFactory.setAuthMethod(authMethod.getName());
                    this.promise.complete();
                }
            } else {
                onError.handle((Object)response.toException("AUTH " + authMethod.getName() + " failed", this.connection.getCapa().isCapaEnhancedStatusCodes()));
            }
        });
    }
}

