/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.ext.auth.prng.PRNG;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPEndPoint;
import io.vertx.ext.mail.impl.SMTPReset;
import io.vertx.ext.mail.impl.SMTPStarter;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class SMTPConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnectionPool.class);
    private static final int RSET_MAX_RETRY = Integer.getInteger("vertx.mail.rset.max.retry", 5);
    private final PRNG prng;
    private final AuthOperationFactory authOperationFactory;
    private final Vertx vertx;
    private final NetClient netClient;
    private final MailConfig config;
    private boolean closed = false;
    private final AtomicReference<SMTPEndPoint> endPoint = new AtomicReference();
    private long timerID = -1L;

    public SMTPConnectionPool(Vertx vertx, MailConfig config) {
        this.vertx = vertx;
        this.config = config;
        String verification = config.getHostnameVerificationAlgorithm();
        if (!(verification != null && !verification.isEmpty() || config.isTrustAll() || !config.isSsl() && config.getStarttls() == StartTLSOptions.DISABLED)) {
            config.setHostnameVerificationAlgorithm("HTTPS");
        } else {
            config.setHostnameVerificationAlgorithm("");
        }
        this.netClient = vertx.createNetClient((NetClientOptions)config);
        this.prng = new PRNG(vertx);
        this.authOperationFactory = new AuthOperationFactory(this.prng);
        if (config.getPoolCleanerPeriod() > 0 && config.isKeepAlive() && config.getKeepAliveTimeout() > 0) {
            this.timerID = vertx.setTimer(SMTPConnectionPool.poolCleanTimeout(config), this::checkExpired);
        }
    }

    private static long poolCleanTimeout(MailConfig config) {
        return config.getPoolCleanerPeriodUnit().toMillis(config.getPoolCleanerPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired(long timer) {
        this.getSMTPEndPoint().checkExpired2().onSuccess(conns -> conns.forEach(SMTPConnection::quitCloseConnection));
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (!this.closed) {
                this.timerID = this.vertx.setTimer(SMTPConnectionPool.poolCleanTimeout(this.config), this::checkExpired);
            }
        }
    }

    public AuthOperationFactory getAuthOperationFactory() {
        return this.authOperationFactory;
    }

    public Future<SMTPConnection> getConnection(String hostname) {
        return this.getConnection(hostname, this.vertx.getOrCreateContext());
    }

    Future<SMTPConnection> getConnection(String hostname, Context ctx) {
        return this.getConnection0(hostname, ctx, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<SMTPConnection> getConnection0(String hostname, Context ctx, int retryAttempt) {
        ContextInternal contextInternal = (ContextInternal)ctx;
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (this.closed) {
                return contextInternal.failedFuture("connection pool is closed");
            }
        }
        return this.getSMTPEndPoint().requestConnection(contextInternal, this.config.getConnectTimeout()).map(l -> ((SMTPConnection)l.get()).setLease((Lease<SMTPConnection>)l)).flatMap(conn -> {
            Future future;
            boolean reset;
            conn.setInUse();
            if (conn.isInitialized()) {
                reset = true;
                future = new SMTPReset((SMTPConnection)conn).start(contextInternal).map(ignored -> conn);
            } else {
                reset = false;
                future = conn.init().flatMap(new SMTPStarter(contextInternal, (SMTPConnection)conn, this.config, hostname, this.authOperationFactory)::serverGreeting).map(ignored -> conn);
            }
            return future.recover(t -> {
                PromiseInternal quitPromise = contextInternal.promise();
                if (t instanceof IOException) {
                    conn.shutdown();
                    quitPromise.fail(t);
                } else {
                    conn.quitCloseConnection().onComplete((Completable)quitPromise);
                }
                return quitPromise.future().transform(v -> {
                    if (reset && retryAttempt < RSET_MAX_RETRY) {
                        log.debug((Object)("Failed on RSET, try " + (retryAttempt + 1) + " time"));
                        return this.getConnection0(hostname, ctx, retryAttempt + 1);
                    }
                    conn.shutdown();
                    return contextInternal.failedFuture(t);
                });
            });
        });
    }

    private SMTPEndPoint getSMTPEndPoint() {
        return this.endPoint.accumulateAndGet(this.endPoint.get(), (p, n) -> p == null ? new SMTPEndPoint(this.netClient, this.config, this.endPoint) : p);
    }

    public void close() {
        this.doClose().onComplete(h -> {
            if (h.failed()) {
                log.warn((Object)"Failed to close the pool", h.cause());
            }
            log.debug((Object)"SMTP connection pool closed.");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> doClose() {
        log.debug((Object)"trying to close the connection pool");
        SMTPConnectionPool sMTPConnectionPool = this;
        synchronized (sMTPConnectionPool) {
            if (this.closed) {
                throw new IllegalStateException("pool is already closed");
            }
            this.closed = true;
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.prng.close();
        return this.getSMTPEndPoint().doClose().flatMap(list -> {
            List futures = list.stream().map(connFuture -> ((SMTPConnection)connFuture.result()).close()).collect(Collectors.toList());
            return Future.all(futures);
        }).flatMap(f -> this.netClient.close()).eventually(() -> {
            log.debug((Object)"Close net client");
            return Future.succeededFuture();
        });
    }

    public int connCount() {
        return this.getSMTPEndPoint().size();
    }

    public NetClient netClient() {
        return this.netClient;
    }
}

