/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.mail.impl.sasl.AuthBaseClass;
import io.vertx.ext.mail.impl.sasl.CryptUtils;
import java.util.HashMap;
import java.util.Map;

public class AuthCram
extends AuthBaseClass {
    private boolean firstStep = true;
    private boolean finished = false;
    private final String hmac;
    private static final Map<String, String> NAME_MAC_MAP = new HashMap<String, String>(){
        {
            this.put("CRAM-SHA256", "HmacSHA256");
            this.put("CRAM-SHA1", "HmacSHA1");
            this.put("CRAM-MD5", "HmacMD5");
        }
    };

    public AuthCram(String name, String username, String password) {
        super(name, username, password);
        this.hmac = NAME_MAC_MAP.get(name);
    }

    @Override
    public String nextStep(String data) {
        if (this.finished) {
            return null;
        }
        if (this.firstStep) {
            this.firstStep = false;
            return "";
        }
        this.finished = true;
        String reply = CryptUtils.hmacHex(this.password, data, this.hmac);
        return this.username + " " + reply;
    }
}

