package io.vertx.ext.mail;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.ext.mail.DKIMSignOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.DKIMSignOptions} original class using Vert.x codegen.
 */
public class DKIMSignOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, DKIMSignOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "signAlgo":
          if (member.getValue() instanceof String) {
            obj.setSignAlgo(io.vertx.ext.mail.DKIMSignAlgorithm.valueOf((String)member.getValue()));
          }
          break;
        case "privateKey":
          if (member.getValue() instanceof String) {
            obj.setPrivateKey((String)member.getValue());
          }
          break;
        case "privateKeyPath":
          if (member.getValue() instanceof String) {
            obj.setPrivateKeyPath((String)member.getValue());
          }
          break;
        case "signedHeaders":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<java.lang.String> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof String)
                list.add((String)item);
            });
            obj.setSignedHeaders(list);
          }
          break;
        case "sdid":
          if (member.getValue() instanceof String) {
            obj.setSdid((String)member.getValue());
          }
          break;
        case "selector":
          if (member.getValue() instanceof String) {
            obj.setSelector((String)member.getValue());
          }
          break;
        case "headerCanonAlgo":
          if (member.getValue() instanceof String) {
            obj.setHeaderCanonAlgo(io.vertx.ext.mail.CanonicalizationAlgorithm.valueOf((String)member.getValue()));
          }
          break;
        case "bodyCanonAlgo":
          if (member.getValue() instanceof String) {
            obj.setBodyCanonAlgo(io.vertx.ext.mail.CanonicalizationAlgorithm.valueOf((String)member.getValue()));
          }
          break;
        case "auid":
          if (member.getValue() instanceof String) {
            obj.setAuid((String)member.getValue());
          }
          break;
        case "bodyLimit":
          if (member.getValue() instanceof Number) {
            obj.setBodyLimit(((Number)member.getValue()).intValue());
          }
          break;
        case "signatureTimestamp":
          if (member.getValue() instanceof Boolean) {
            obj.setSignatureTimestamp((Boolean)member.getValue());
          }
          break;
        case "expireTime":
          if (member.getValue() instanceof Number) {
            obj.setExpireTime(((Number)member.getValue()).longValue());
          }
          break;
        case "copiedHeaders":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<java.lang.String> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof String)
                list.add((String)item);
            });
            obj.setCopiedHeaders(list);
          }
          break;
      }
    }
  }

   static void toJson(DKIMSignOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(DKIMSignOptions obj, java.util.Map<String, Object> json) {
    if (obj.getSignAlgo() != null) {
      json.put("signAlgo", obj.getSignAlgo().name());
    }
    if (obj.getPrivateKey() != null) {
      json.put("privateKey", obj.getPrivateKey());
    }
    if (obj.getPrivateKeyPath() != null) {
      json.put("privateKeyPath", obj.getPrivateKeyPath());
    }
    if (obj.getSignedHeaders() != null) {
      JsonArray array = new JsonArray();
      obj.getSignedHeaders().forEach(item -> array.add(item));
      json.put("signedHeaders", array);
    }
    if (obj.getSdid() != null) {
      json.put("sdid", obj.getSdid());
    }
    if (obj.getSelector() != null) {
      json.put("selector", obj.getSelector());
    }
    if (obj.getHeaderCanonAlgo() != null) {
      json.put("headerCanonAlgo", obj.getHeaderCanonAlgo().name());
    }
    if (obj.getBodyCanonAlgo() != null) {
      json.put("bodyCanonAlgo", obj.getBodyCanonAlgo().name());
    }
    if (obj.getAuid() != null) {
      json.put("auid", obj.getAuid());
    }
    json.put("bodyLimit", obj.getBodyLimit());
    json.put("signatureTimestamp", obj.isSignatureTimestamp());
    json.put("expireTime", obj.getExpireTime());
    if (obj.getCopiedHeaders() != null) {
      JsonArray array = new JsonArray();
      obj.getCopiedHeaders().forEach(item -> array.add(item));
      json.put("copiedHeaders", array);
    }
  }
}
