/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.Capabilities;
import io.vertx.ext.mail.impl.MultilineParser;
import io.vertx.ext.mail.impl.SMTPResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class SMTPConnection {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnection.class);
    private static final Pattern linePattern = Pattern.compile("\r\n");
    private final NetSocket ns;
    private final MailConfig config;
    private Lease<SMTPConnection> lease;
    private MultilineParser nsHandler;
    private final Handler<Void> evictionHandler;
    private boolean evicted;
    private boolean socketClosed;
    private boolean shutdown;
    private boolean inuse;
    private boolean quitSent;
    private Completable<String> commandReplyHandler;
    private Handler<Throwable> exceptionHandler;
    private Completable<Void> closeHandler;
    private Capabilities capa = new Capabilities();
    private final ContextInternal context;
    private long expirationTimestamp;
    private final AtomicLong emailsSent;

    SMTPConnection(MailConfig config, NetSocket ns, ContextInternal context, Handler<Void> evictionHandler) {
        this.config = config;
        this.ns = ns;
        this.context = context;
        this.evictionHandler = evictionHandler;
        this.emailsSent = new AtomicLong(0L);
    }

    private static long expirationTimestampOf(MailConfig config) {
        long timeout = config.getKeepAliveTimeout();
        return timeout == 0L ? 0L : System.currentTimeMillis() + config.getKeepAliveTimeoutUnit().toMillis(timeout);
    }

    SMTPConnection setLease(Lease<SMTPConnection> lease) {
        this.lease = lease;
        return this;
    }

    boolean isInitialized() {
        return this.nsHandler != null;
    }

    Future<String> init() {
        PromiseInternal promise;
        if (this.nsHandler != null) {
            return this.context.failedFuture((Throwable)new IllegalStateException("SMTPConnection has been initialized."));
        }
        this.nsHandler = new MultilineParser((Handler<Buffer>)((Handler)buffer -> {
            if (this.commandReplyHandler == null && !this.quitSent) {
                log.error((Object)"dropping reply arriving after we stopped processing the buffer.");
            } else {
                Completable<String> currentHandler = this.commandReplyHandler;
                this.commandReplyHandler = null;
                if (currentHandler != null) {
                    currentHandler.succeed((Object)buffer.toString());
                }
            }
        }));
        this.commandReplyHandler = promise = this.context.promise();
        this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
        this.ns.handler((Handler)this.nsHandler);
        this.ns.exceptionHandler(this::handleNSException);
        this.ns.closeHandler(this::handleNSClosed);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNSException(Throwable t) {
        if (this.isAvailable()) {
            Handler<Throwable> handler;
            SMTPConnection sMTPConnection = this;
            synchronized (sMTPConnection) {
                handler = this.exceptionHandler;
            }
            this.shutdown();
            if (this.quitSent) {
                log.debug((Object)"got an exception on the netsocket after quit sent", t);
            } else if (handler != null) {
                this.context.emit((Object)t, handler);
            }
        } else {
            log.debug((Object)"not returning follow-up exception", t);
        }
    }

    private boolean isAvailable() {
        return !this.socketClosed && !this.shutdown;
    }

    boolean isValid() {
        return (this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp) && !this.quitSent;
    }

    void handleNSClosed(Void v) {
        log.trace((Object)"handleNSClosed() - socket has been closed");
        boolean unexpected = false;
        this.socketClosed = true;
        if (!this.shutdown && !this.quitSent) {
            this.handleError(new IOException("socket was closed unexpected."));
            unexpected = true;
        }
        if (unexpected) {
            this.shutdown();
        }
        this.handleClosed();
    }

    private void handleClosed() {
        this.setNoUse();
        if (this.closeHandler != null) {
            this.closeHandler.succeed();
            this.closeHandler = null;
        }
        if (!this.evicted) {
            this.evicted = true;
            this.evictionHandler.handle(null);
            this.cleanHandlers();
        }
        this.emailsSent.set(0L);
    }

    void shutdown() {
        this.shutdown = true;
        if (!this.socketClosed) {
            this.socketClosed = true;
            this.ns.close();
        }
        this.handleClosed();
    }

    private void cleanHandlers() {
        this.exceptionHandler = null;
        this.commandReplyHandler = null;
    }

    public Future<Void> returnToPool() {
        log.trace((Object)"return to pool");
        this.setNoUse();
        PromiseInternal promise = this.context.promise();
        try {
            boolean exceed;
            long count = this.emailsSent.incrementAndGet();
            boolean bl = exceed = this.config.getMaxMailsPerConnection() > 0L && count >= this.config.getMaxMailsPerConnection();
            if (!this.config.isKeepAlive() || this.closeHandler != null || exceed) {
                this.quitCloseConnection().onComplete(arg_0 -> this.lambda$returnToPool$1((Promise)promise, arg_0));
            } else {
                log.trace((Object)"recycle for next use");
                this.cleanHandlers();
                this.lease.recycle();
                this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
                promise.complete();
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    Future<Void> quitCloseConnection() {
        this.quitSent = true;
        this.setNoUse();
        return this.writeLineWithDrain("QUIT", true);
    }

    void setExceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    void setInUse() {
        this.inuse = true;
        this.expirationTimestamp = SMTPConnection.expirationTimestampOf(this.config);
    }

    void setNoUse() {
        this.inuse = false;
    }

    Future<Void> close() {
        PromiseInternal promise;
        if (!this.isAvailable()) {
            return this.context.succeededFuture();
        }
        if (!this.inuse) {
            log.trace((Object)"close by sending quit in close()");
            return this.quitCloseConnection();
        }
        this.closeHandler = promise = this.context.promise();
        if (this.quitSent) {
            this.shutdown();
        }
        return promise.future();
    }

    private void handleError(Throwable t) {
        this.context.emit(roc -> {
            Completable<String> currentHandler = this.commandReplyHandler;
            if (currentHandler != null) {
                this.commandReplyHandler = null;
                currentHandler.fail(t);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)t.getMessage(), t);
            }
        });
    }

    Capabilities getCapa() {
        return this.capa;
    }

    void parseCapabilities(String message) {
        this.capa = new Capabilities();
        this.capa.parseCapabilities(message);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Supported Auth methods: ");
            this.capa.getCapaAuth().forEach(a -> sb.append((String)a).append(" "));
            sb.append("\n");
            if (this.capa.getSize() > 0) {
                sb.append("Max Size: ").append(this.capa.getSize()).append("\n");
            }
            sb.append("Support STARTTLS: ").append(this.capa.isStartTLS()).append(", Current connection TLS: ").append(this.isSsl()).append("\n");
            sb.append("Support PIPELINING: ").append(this.capa.isCapaPipelining()).append("\n");
            sb.append("Support ENHANCEDSTATUSCODES: ").append(this.capa.isCapaEnhancedStatusCodes()).append("\n");
            log.debug((Object)sb);
        }
    }

    Future<SMTPResponse[]> writeCommands(List<String> commands) {
        String cmds = String.join((CharSequence)"\r\n", commands);
        this.nsHandler.setExpected(commands.size());
        return this.doWrite(cmds, -1).map(response -> {
            try {
                String[] lines = linePattern.split((CharSequence)response);
                SMTPResponse[] result = new SMTPResponse[lines.length];
                for (int i = 0; i < lines.length; ++i) {
                    String message = lines[i];
                    result[i] = new SMTPResponse(message);
                }
                SMTPResponse[] sMTPResponseArray = result;
                return sMTPResponseArray;
            }
            finally {
                this.nsHandler.setExpected(1);
            }
        });
    }

    public Future<SMTPResponse> write(String str) {
        return this.doWrite(str, -1).map(SMTPResponse::new);
    }

    Future<SMTPResponse> write(String str, int blank) {
        return this.doWrite(str, blank).map(SMTPResponse::new);
    }

    private Future<String> doWrite(String str, int blank) {
        PromiseInternal promise = this.context.promise();
        this.context.emit(arg_0 -> this.lambda$doWrite$6(blank, str, (Promise)promise, arg_0));
        return promise.future();
    }

    public Future<Void> writeLineWithDrain(String str, boolean mayLog) {
        if (mayLog) {
            log.debug((Object)str);
        }
        PromiseInternal promise = this.context.promise();
        this.context.emit(arg_0 -> this.lambda$writeLineWithDrain$8(str, (Promise)promise, arg_0));
        return promise.future();
    }

    boolean isSsl() {
        return this.ns.isSsl();
    }

    Future<Void> upgradeToSsl() {
        return this.ns.upgradeToSsl();
    }

    public boolean isClosed() {
        return this.socketClosed;
    }

    Context getContext() {
        return this.context;
    }

    NetSocket getSocket() {
        return this.ns;
    }

    private /* synthetic */ void lambda$writeLineWithDrain$8(String str, Promise promise, Void roc) {
        if (this.isAvailable()) {
            if (this.ns.writeQueueFull()) {
                this.ns.drainHandler(v -> {
                    this.ns.drainHandler(null);
                    this.ns.write(str + "\r\n").onComplete((Completable)promise);
                });
            } else {
                this.ns.write(str + "\r\n").onComplete((Completable)promise);
            }
        } else {
            promise.fail("Connection was closed.");
        }
    }

    private /* synthetic */ void lambda$doWrite$6(int blank, String str, Promise promise, Void roc) {
        if (log.isDebugEnabled()) {
            Object logStr;
            if (blank >= 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = blank; i < str.length(); ++i) {
                    sb.append('*');
                }
                logStr = str.substring(0, blank) + String.valueOf(sb);
            } else {
                logStr = str;
            }
            if (((String)logStr).length() < 1000) {
                log.debug((Object)("command: " + (String)logStr));
            } else {
                log.debug((Object)("command: " + ((String)logStr).substring(0, 1000) + "..."));
            }
        }
        this.commandReplyHandler = promise;
        this.ns.write(str + "\r\n").onFailure(t -> {
            this.handleError((Throwable)t);
            this.shutdown();
        });
    }

    private /* synthetic */ void lambda$returnToPool$1(Promise promise, AsyncResult ignored) {
        this.handleClosed();
        promise.complete();
    }
}

