/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;

class SMTPInitialDialogue {
    private static final Logger log = LoggerFactory.getLogger(SMTPInitialDialogue.class);
    private final SMTPConnection connection;
    private final MailConfig config;
    private final String hostname;
    private final Promise<Void> promise;

    public SMTPInitialDialogue(ContextInternal context, SMTPConnection connection, MailConfig config, String hostname) {
        this.connection = connection;
        this.config = config;
        this.hostname = hostname;
        this.promise = context.promise();
        this.connection.setExceptionHandler((Handler<Throwable>)((Handler)arg_0 -> this.promise.fail(arg_0)));
    }

    public Future<Void> start(String serverGreeting) {
        SMTPResponse response = new SMTPResponse(serverGreeting);
        if (response.isStatusOk()) {
            if (this.config.isDisableEsmtp()) {
                this.helo();
            } else {
                this.ehlo();
            }
        } else {
            this.promise.fail((Throwable)((Object)response.toException("got error response")));
        }
        return this.promise.future();
    }

    private void ehlo() {
        this.connection.write("EHLO " + this.hostname).onComplete(ar -> {
            if (ar.failed()) {
                this.promise.fail(ar.cause());
                return;
            }
            SMTPResponse response = (SMTPResponse)ar.result();
            if (response.isStatusOk()) {
                this.connection.parseCapabilities(response.getValue());
                if (this.connection.getCapa().isStartTLS() && !this.connection.isSsl() && (this.config.getStarttls() == StartTLSOptions.REQUIRED || this.config.getStarttls() == StartTLSOptions.OPTIONAL)) {
                    this.startTLS();
                } else {
                    this.finished();
                }
            } else {
                this.helo();
            }
        });
    }

    private void helo() {
        this.connection.write("HELO " + this.hostname).onComplete(ar -> {
            if (ar.failed()) {
                this.promise.fail(ar.cause());
                return;
            }
            SMTPResponse response = (SMTPResponse)ar.result();
            if (response.isStatusOk()) {
                this.finished();
            } else {
                this.promise.fail((Throwable)((Object)response.toException("HELO failed.")));
            }
        });
    }

    private void startTLS() {
        this.connection.write("STARTTLS").flatMap(ignored -> this.connection.upgradeToSsl()).onComplete(ar -> {
            if (ar.failed()) {
                this.promise.fail(ar.cause());
                return;
            }
            log.trace((Object)"tls started");
            this.ehlo();
        });
    }

    private void finished() {
        if (this.connection.isSsl() || this.config.getStarttls() != StartTLSOptions.REQUIRED) {
            this.promise.complete();
        } else {
            log.warn((Object)"STARTTLS required but not supported by server");
            this.promise.fail("STARTTLS required but not supported by server");
        }
    }
}

