/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.ext.mail.SMTPException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SMTPResponse {
    private final int replyCode;
    private final String message;

    public SMTPResponse(String message) {
        Objects.requireNonNull(message, "SMTP response should not be null.");
        this.replyCode = SMTPResponse.getStatusCode(message);
        this.message = message;
    }

    private static int getStatusCode(String message) {
        if (message.length() < 4) {
            return 500;
        }
        if (message.charAt(3) != ' ' && message.charAt(3) != '-') {
            return 500;
        }
        try {
            return Integer.parseInt(message.substring(0, 3));
        }
        catch (NumberFormatException n) {
            return 500;
        }
    }

    public String getValue() {
        return this.message;
    }

    public boolean isStatusOk() {
        return this.replyCode >= 200 && this.replyCode < 400;
    }

    public boolean isStatusContinue() {
        return this.replyCode >= 300 && this.replyCode < 400;
    }

    SMTPException toException(String message) {
        return this.toException(message, false);
    }

    SMTPException toException(String message, boolean supportEnhancementStatusCode) {
        if (this.isStatusOk()) {
            throw new IllegalStateException("Status is OK, no exceptions");
        }
        List<String> replyLines = Arrays.asList(this.message.split("\n"));
        return new SMTPException(message, this.replyCode, replyLines, supportEnhancementStatusCode);
    }
}

