/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;
import io.vertx.ext.mail.mailencoder.EmailAddress;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SMTPSendMail {
    private static final Logger log = LoggerFactory.getLogger(SMTPSendMail.class);
    private static final Pattern linePattern = Pattern.compile("\r\n");
    private final ContextInternal context;
    private final SMTPConnection connection;
    private final MailMessage email;
    private final MailConfig config;
    private final MailResult mailResult;
    private final EncodedPart encodedPart;
    private final AtomicLong written = new AtomicLong();

    public SMTPSendMail(ContextInternal context, SMTPConnection connection, MailMessage email, MailConfig config, EncodedPart encodedPart, String messageId) {
        this.context = context;
        this.connection = connection;
        this.email = email;
        this.config = config;
        this.mailResult = new MailResult();
        this.encodedPart = encodedPart;
        this.mailResult.setMessageID(messageId);
    }

    public Future<MailResult> startMailTransaction() {
        return this.sendMailEvenlope().flatMap(this::sendMailData);
    }

    private boolean checkSize() {
        int size = this.connection.getCapa().getSize();
        return size == 0 || size >= this.encodedPart.size();
    }

    private String mailFromAddress() {
        String bounceAddr = this.email.getBounceAddress();
        String fromAddr = bounceAddr != null && !bounceAddr.isEmpty() ? bounceAddr : this.email.getFrom();
        EmailAddress from = new EmailAddress(fromAddr);
        return from.getEmail();
    }

    private String sizeParameter() {
        Object sizeParameter = this.connection.getCapa().getSize() > 0 ? " SIZE=" + this.encodedPart.size() : "";
        return sizeParameter;
    }

    private List<String> allRecipients() {
        ArrayList<String> recipientAddrs = new ArrayList<String>();
        if (this.email.getTo() != null) {
            recipientAddrs.addAll(this.email.getTo());
        }
        if (this.email.getCc() != null) {
            recipientAddrs.addAll(this.email.getCc());
        }
        if (this.email.getBcc() != null) {
            recipientAddrs.addAll(this.email.getBcc());
        }
        return recipientAddrs.stream().map(r -> {
            String email = "postmaster".equalsIgnoreCase((String)r) ? r : new EmailAddress((String)r).getEmail();
            return email;
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Future<Boolean> sendMailEvenlope() {
        PromiseInternal envelopePromise = this.context.promise();
        try {
            if (!this.checkSize()) {
                envelopePromise.fail("message exceeds allowed size limit");
                return envelopePromise.future();
            }
            String mailFromLine = "MAIL FROM:<" + this.mailFromAddress() + ">" + this.sizeParameter();
            List<String> allRecipients = this.allRecipients();
            if (this.config.isPipelining() && this.connection.getCapa().isCapaPipelining()) {
                ArrayList<String> groupCommands = new ArrayList<String>();
                groupCommands.add(mailFromLine);
                groupCommands.addAll(allRecipients.stream().map(r -> "RCPT TO:<" + r + ">").collect(Collectors.toList()));
                groupCommands.add("DATA");
                this.connection.writeCommands(groupCommands).onComplete(arg_0 -> this.lambda$sendMailEvenlope$2((Promise)envelopePromise, groupCommands, allRecipients, arg_0));
                return envelopePromise.future();
            }
            Future future = this.sendMailFrom(mailFromLine);
            Iterator<String> iterator = allRecipients.iterator();
            while (iterator.hasNext()) {
                String email = iterator.next();
                future = future.flatMap(v -> this.sendRcptTo(email));
            }
            return future.flatMap(v -> this.sendDataCmd());
        }
        catch (Exception e) {
            envelopePromise.fail((Throwable)e);
        }
        return envelopePromise.future();
    }

    private Future<Void> sendMailFrom(String mailFromLine) {
        PromiseInternal promise = this.context.promise();
        this.connection.write(mailFromLine).onComplete(arg_0 -> this.lambda$sendMailFrom$5(mailFromLine, (Promise)promise, arg_0));
        return promise.future();
    }

    private Future<Void> sendRcptTo(String email) {
        PromiseInternal promise = this.context.promise();
        try {
            String line = "RCPT TO:<" + email + ">";
            this.connection.write(line).onComplete(arg_0 -> this.lambda$sendRcptTo$6(line, (Promise)promise, email, arg_0));
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<Boolean> sendDataCmd() {
        PromiseInternal promise = this.context.promise();
        try {
            if (this.mailResult.getRecipients().size() > 0) {
                this.connection.write("DATA").onComplete(arg_0 -> this.lambda$sendDataCmd$7((Promise)promise, arg_0));
            } else {
                promise.fail("no recipient addresses were accepted, not sending mail");
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<MailResult> sendMailData(boolean includeData) {
        if (!includeData) {
            return this.sendEndDot();
        }
        return this.sendMailHeaders(this.encodedPart.headers()).flatMap(v -> this.sendMailBody()).flatMap(v -> this.sendEndDot());
    }

    private Future<Void> sendMailHeaders(MultiMap headers) {
        StringBuilder sb = new StringBuilder();
        headers.forEach(header -> sb.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n"));
        String headerLines = sb.toString();
        return this.connection.writeLineWithDrain(headerLines, this.written.getAndAdd(headerLines.length()) < 1000L);
    }

    private Future<MailResult> sendEndDot() {
        PromiseInternal promise = this.context.promise();
        try {
            this.connection.getContext().runOnContext(arg_0 -> this.lambda$sendEndDot$12((Promise)promise, arg_0));
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<Void> sendMailBody() {
        PromiseInternal promise = this.context.promise();
        EncodedPart part = this.encodedPart;
        try {
            if (this.isMultiPart(part)) {
                this.sendMultiPart(part, 0, (Promise<Void>)promise);
            } else {
                this.sendRegularPartBody(part, (Promise<Void>)promise);
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private void sendMultiPart(EncodedPart multiPart, int i, Promise<Void> promise) {
        try {
            String boundaryStart = "--" + multiPart.boundary();
            EncodedPart thePart = multiPart.parts().get(i);
            PromiseInternal boundaryStartPromise = this.context.promise();
            boundaryStartPromise.future().compose(v -> this.sendMailHeaders(thePart.headers())).onComplete(v -> {
                if (v.succeeded()) {
                    PromiseInternal nextPromise = this.context.promise();
                    nextPromise.future().onComplete(vv -> {
                        if (vv.succeeded()) {
                            if (i == multiPart.parts().size() - 1) {
                                String boundaryEnd;
                                this.connection.writeLineWithDrain(boundaryEnd, this.written.getAndAdd((boundaryEnd = boundaryStart + "--").length()) < 1000L).onComplete((Completable)promise);
                            } else {
                                this.sendMultiPart(multiPart, i + 1, promise);
                            }
                        } else {
                            promise.fail(vv.cause());
                        }
                    });
                    if (this.isMultiPart(thePart)) {
                        this.sendMultiPart(thePart, 0, (Promise<Void>)nextPromise);
                    } else {
                        this.sendRegularPartBody(thePart, (Promise<Void>)nextPromise);
                    }
                } else {
                    promise.fail(v.cause());
                }
            });
            this.connection.writeLineWithDrain(boundaryStart, this.written.getAndAdd(boundaryStart.length()) < 1000L).onComplete((Completable)boundaryStartPromise);
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }

    private boolean isMultiPart(EncodedPart part) {
        return part.parts() != null && part.parts().size() > 0;
    }

    private void sendBodyLineByLine(String[] lines, int i, Promise<Void> promise) {
        if (i < lines.length) {
            Object line = lines[i];
            if (((String)line).startsWith(".")) {
                line = "." + (String)line;
            }
            this.connection.writeLineWithDrain((String)line, this.written.getAndAdd(((String)line).length()) < 1000L).onComplete(v -> {
                if (v.succeeded()) {
                    this.sendBodyLineByLine(lines, i + 1, promise);
                } else {
                    promise.fail(v.cause());
                }
            });
        } else {
            promise.complete();
        }
    }

    private void sendRegularPartBody(EncodedPart part, Promise<Void> promise) {
        if (part.body() != null) {
            this.sendBodyLineByLine(part.body().split("\n"), 0, promise);
        } else {
            ReadStream<Buffer> attachBodyStream = part.bodyStream(this.connection.getContext());
            if (attachBodyStream != null) {
                attachBodyStream.pipe().endOnComplete(false).to((WriteStream)this.connection.getSocket()).onComplete(promise);
            } else {
                promise.fail((Throwable)new IllegalStateException("No mail body and stream found"));
            }
        }
    }

    private /* synthetic */ void lambda$sendEndDot$12(Promise promise, Void v) {
        this.connection.write(".").onComplete(ar -> {
            SMTPResponse response;
            if (ar.failed()) {
                promise.fail(ar.cause());
            }
            if ((response = (SMTPResponse)ar.result()).isStatusOk()) {
                promise.complete((Object)this.mailResult);
            } else {
                promise.fail((Throwable)((Object)response.toException("sending data failed", this.connection.getCapa().isCapaEnhancedStatusCodes())));
            }
        });
    }

    private /* synthetic */ void lambda$sendDataCmd$7(Promise promise, AsyncResult ar) {
        if (log.isDebugEnabled()) {
            this.written.getAndAdd(4L);
        }
        if (ar.failed()) {
            promise.fail(ar.cause());
            return;
        }
        SMTPResponse response = (SMTPResponse)ar.result();
        if (response.isStatusOk()) {
            promise.complete((Object)true);
        } else {
            promise.fail((Throwable)((Object)response.toException("DATA command not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
        }
    }

    private /* synthetic */ void lambda$sendRcptTo$6(String line, Promise promise, String email, AsyncResult ar) {
        if (log.isDebugEnabled()) {
            this.written.getAndAdd(line.length());
        }
        if (ar.failed()) {
            promise.fail(ar.cause());
            return;
        }
        SMTPResponse response = (SMTPResponse)ar.result();
        try {
            if (response.isStatusOk()) {
                this.mailResult.getRecipients().add(email);
                promise.complete();
            } else if (this.config.isAllowRcptErrors()) {
                promise.complete();
            } else {
                promise.fail((Throwable)((Object)response.toException("recipient address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$sendMailFrom$5(String mailFromLine, Promise promise, AsyncResult ar) {
        if (log.isDebugEnabled()) {
            this.written.getAndAdd(mailFromLine.length());
        }
        if (ar.failed()) {
            promise.fail(ar.cause());
            return;
        }
        SMTPResponse response = (SMTPResponse)ar.result();
        if (response.isStatusOk()) {
            promise.complete();
        } else {
            promise.fail((Throwable)((Object)response.toException("sender address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
        }
    }

    private /* synthetic */ void lambda$sendMailEvenlope$2(Promise envelopePromise, List groupCommands, List allRecipients, AsyncResult ar) {
        if (ar.failed()) {
            envelopePromise.fail(ar.cause());
            return;
        }
        SMTPResponse[] evenlopeResult = (SMTPResponse[])ar.result();
        if (groupCommands.size() != evenlopeResult.length) {
            envelopePromise.fail("Sent " + groupCommands.size() + " commands, but got " + evenlopeResult.length + " responses.");
        } else {
            for (int i = 0; i < evenlopeResult.length; ++i) {
                SMTPResponse response = evenlopeResult[i];
                if (i == 0) {
                    if (response.isStatusOk()) continue;
                    envelopePromise.fail((Throwable)((Object)response.toException("sender address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                    return;
                }
                if (i < evenlopeResult.length - 1) {
                    if (response.isStatusOk()) {
                        this.mailResult.getRecipients().add((String)allRecipients.get(i - 1));
                        continue;
                    }
                    if (this.config.isAllowRcptErrors()) continue;
                    envelopePromise.fail((Throwable)((Object)response.toException("recipient address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                    return;
                }
                if (response.isStatusOk()) {
                    if (this.mailResult.getRecipients().size() != 0) continue;
                    envelopePromise.complete((Object)false);
                    return;
                }
                envelopePromise.fail((Throwable)((Object)response.toException("DATA command not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                return;
            }
            envelopePromise.complete((Object)true);
        }
    }
}

