/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.mail.DKIMSignOptions;
import io.vertx.ext.mail.MailClient;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPConnectionPool;
import io.vertx.ext.mail.impl.SMTPSendMail;
import io.vertx.ext.mail.impl.Utils;
import io.vertx.ext.mail.impl.dkim.DKIMSigner;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.MailEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MailClientImpl
implements MailClient {
    private static final Logger log = LoggerFactory.getLogger(MailClientImpl.class);
    private static final String POOL_LOCAL_MAP_NAME = "__vertx.MailClient.pools";
    private final Vertx vertx;
    private final MailConfig config;
    private final SMTPConnectionPool connectionPool;
    private final MailHolder holder;
    private volatile String hostname = null;
    private volatile boolean closed = false;
    private final List<DKIMSigner> dkimSigners;

    public MailClientImpl(Vertx vertx, MailConfig config, String poolName) {
        this.vertx = vertx;
        this.config = config;
        this.holder = this.lookupHolder(poolName, config);
        this.connectionPool = this.holder.pool();
        this.dkimSigners = config != null && config.isEnableDKIM() && config.getDKIMSignOptions() != null ? config.getDKIMSignOptions().stream().map(ops -> new DKIMSigner((DKIMSignOptions)ops, vertx)).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public Future<Void> close() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.closed = true;
        return this.holder.close();
    }

    @Override
    public Future<MailResult> sendMail(MailMessage email) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = context.promise();
        if (!this.closed) {
            this.validateHeaders(email, context).flatMap(ignored -> this.getHostname()).flatMap(arg_0 -> this.lambda$sendMail$2((Promise)promise, context, arg_0)).flatMap(conn -> this.sendMessage(email, (SMTPConnection)conn, context).compose(result -> conn.returnToPool().transform(ignored -> context.succeededFuture(result)), failure -> conn.quitCloseConnection().transform(ignored -> context.failedFuture(failure)))).onComplete((Completable)promise);
        } else {
            promise.fail("mail client has been closed");
        }
        return promise.future();
    }

    private Future<Void> validateHeaders(MailMessage email, ContextInternal context) {
        if (email.getBounceAddress() == null && email.getFrom() == null) {
            return context.failedFuture("sender address is not present");
        }
        if (!(email.getTo() != null && email.getTo().size() != 0 || email.getCc() != null && email.getCc().size() != 0 || email.getBcc() != null && email.getBcc().size() != 0)) {
            log.warn((Object)"no recipient addresses are present");
            return context.failedFuture("no recipient addresses are present");
        }
        return context.succeededFuture();
    }

    private Future<?> getHostname() {
        if (this.hostname != null) {
            return Future.succeededFuture();
        }
        return this.vertx.executeBlocking(() -> {
            if (this.config.getOwnHostname() != null) {
                return this.config.getOwnHostname();
            }
            return Utils.getHostname();
        }).andThen(res -> {
            if (res.succeeded()) {
                this.hostname = (String)res.result();
            }
        });
    }

    private Future<SMTPConnection> getConnection(Handler<Throwable> errorHandler, ContextInternal context) {
        return this.connectionPool.getConnection(this.hostname, (Context)context).map(conn -> {
            conn.setExceptionHandler(errorHandler);
            return conn;
        });
    }

    private Future<Void> dkimSign(ContextInternal context, EncodedPart encodedPart) {
        if (this.dkimSigners.isEmpty()) {
            return context.succeededFuture();
        }
        ArrayList dkimFutures = new ArrayList();
        this.dkimSigners.forEach(dkim -> dkimFutures.add(dkim.signEmail((Context)context, encodedPart)));
        return Future.all(dkimFutures).map(f -> {
            List dkimHeaders = dkimFutures.stream().map(fr -> ((String)fr.result()).toString()).collect(Collectors.toList());
            encodedPart.headers().add("DKIM-Signature", dkimHeaders);
            return null;
        });
    }

    private Future<MailResult> sendMessage(MailMessage email, SMTPConnection conn, ContextInternal context) {
        try {
            MailEncoder encoder = new MailEncoder(email, this.hostname, this.config);
            EncodedPart encodedPart = encoder.encodeMail();
            String messageId = encoder.getMessageID();
            SMTPSendMail sendMail = new SMTPSendMail(context, conn, email, this.config, encodedPart, messageId);
            return this.dkimSign(context, encodedPart).flatMap(ignored -> sendMail.startMailTransaction());
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
    }

    public SMTPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailHolder lookupHolder(String poolName, MailConfig config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(POOL_LOCAL_MAP_NAME);
            MailHolder theHolder = (MailHolder)map.get((Object)poolName);
            if (theHolder == null) {
                theHolder = new MailHolder(this.vertx, config, () -> this.removeFromMap((LocalMap<String, MailHolder>)map, poolName));
                map.put((Object)poolName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MailHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    private /* synthetic */ Future lambda$sendMail$2(Promise promise, ContextInternal context, Object ignored) {
        return this.getConnection((Handler<Throwable>)((Handler)arg_0 -> ((Promise)promise).fail(arg_0)), context);
    }

    private static class MailHolder
    implements Shareable {
        final SMTPConnectionPool pool;
        final Runnable closeRunner;
        int refCount = 1;

        MailHolder(Vertx vertx, MailConfig config, Runnable closeRunner) {
            this.closeRunner = closeRunner;
            this.pool = new SMTPConnectionPool(vertx, config);
        }

        SMTPConnectionPool pool() {
            return this.pool;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized Future<Void> close() {
            if (--this.refCount == 0) {
                Future<Void> result = this.pool.doClose();
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
                return result;
            }
            return Future.succeededFuture();
        }
    }
}

