/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPConnection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class SMTPEndPoint
implements PoolConnector<SMTPConnection> {
    private final NetClient netClient;
    private final MailConfig config;
    private final ConnectionPool<SMTPConnection> pool;
    private final AtomicReference<SMTPEndPoint> endPoint;
    private final AtomicInteger refCount = new AtomicInteger();

    SMTPEndPoint(NetClient netClient, MailConfig config, AtomicReference<SMTPEndPoint> endPoint) {
        int maxSockets = config.getMaxPoolSize();
        this.config = config;
        this.netClient = netClient;
        this.pool = ConnectionPool.pool((PoolConnector)this, (int[])new int[]{maxSockets}, (int)-1);
        this.endPoint = endPoint;
    }

    public Future<Lease<SMTPConnection>> requestConnection(ContextInternal ctx, long timeout) {
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : ctx.owner().contextBuilder().withEventLoop(ctx.nettyEventLoop()).withWorkerPool(ctx.workerPool()).build();
        return eventLoopContext.future(p -> this.pool.acquire(eventLoopContext, 0, (Completable)p));
    }

    Future<List<SMTPConnection>> checkExpired2() {
        return Future.future(p -> this.pool.evict(conn -> !conn.isValid(), (Completable)p));
    }

    public Future<ConnectResult<SMTPConnection>> connect(ContextInternal context, PoolConnector.Listener listener) {
        return this.netClient.connect(this.config.getPort(), this.config.getHostname()).map(conn -> {
            this.refCount.incrementAndGet();
            SMTPConnection connection = new SMTPConnection(this.config, (NetSocket)conn, context, (Handler<Void>)((Handler)v -> {
                if (this.refCount.decrementAndGet() == 0) {
                    this.cleanup();
                }
                listener.onRemove();
            }));
            return new ConnectResult((Object)connection, 1L, 0L);
        });
    }

    Future<List<Future<SMTPConnection>>> doClose() {
        return Future.future(p -> this.pool.close((Completable)p));
    }

    public boolean isValid(SMTPConnection connection) {
        return connection.isValid();
    }

    int size() {
        return this.pool.size();
    }

    private void cleanup() {
        this.endPoint.set(null);
    }
}

