/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;

public abstract class BaseVertxMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="moduleName", defaultValue="${project.groupId}~${project.artifactId}~${project.version}")
    protected String moduleName;
    @Parameter
    protected File configFile = null;
    @Parameter(defaultValue="1")
    protected Integer instances = 1;
    @Parameter(defaultValue="target/mods")
    protected File modsDir;
    @Parameter(defaultValue="false")
    protected Boolean cluster;
    @Parameter
    protected String clusterHost;
    @Parameter(defaultValue="org.vertx.java.spi.cluster.impl.hazelcast.HazelcastClusterManagerFactory")
    protected String clusterManagerFactory;
    @Parameter(defaultValue="0")
    protected Integer clusterPort;
    @Parameter(defaultValue="false")
    protected Boolean ha;
    @Parameter(defaultValue="__DEFAULT__")
    protected String hagroup;
    @Parameter(defaultValue="0")
    protected Integer quorum;

    protected JsonObject getConf() {
        JsonObject config = null;
        String confContent = this.readConfigFile(this.configFile);
        if (confContent != null && !confContent.isEmpty()) {
            config = new JsonObject(confContent);
        }
        return config;
    }

    private String readConfigFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        try {
            URI uri = file.toURI();
            return new String(Files.readAllBytes(Paths.get(uri)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PlatformManager createPlatformManager() {
        PlatformManager mgr;
        if (this.cluster.booleanValue() || this.ha.booleanValue()) {
            this.getLog().info((CharSequence)"Starting clustering...");
            if (System.getProperty("vertx.clusterManagerFactory", null) == null) {
                this.getLog().debug((CharSequence)("clusterManagerFactory: " + this.clusterManagerFactory));
                System.setProperty("vertx.clusterManagerFactory", this.clusterManagerFactory);
            }
            if (this.clusterHost == null) {
                this.clusterHost = this.getDefaultAddress();
                if (this.clusterHost == null) {
                    this.getLog().error((CharSequence)"Unable to find a default network interface for clustering. Please specify one using cluster-host configuration parameter");
                    return null;
                }
                this.getLog().info((CharSequence)("No cluster-host specified so using address " + this.clusterHost));
            }
            if (this.ha.booleanValue()) {
                int quorumSize = this.quorum == null ? 0 : Integer.valueOf(this.quorum);
                mgr = PlatformLocator.factory.createPlatformManager(this.clusterPort.intValue(), this.clusterHost, quorumSize, this.hagroup);
            } else {
                mgr = PlatformLocator.factory.createPlatformManager(this.clusterPort.intValue(), this.clusterHost);
            }
        } else {
            mgr = PlatformLocator.factory.createPlatformManager();
        }
        return mgr;
    }

    private String getDefaultAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (nets.hasMoreElements()) {
            NetworkInterface netinf = nets.nextElement();
            Enumeration<InetAddress> addresses = netinf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isAnyLocalAddress() || address.isMulticastAddress() || address instanceof Inet6Address) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }

    protected ClassLoader createClassLoader() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.addURLs(urls, "src/main/platform_lib");
        this.addURLs(urls, "src/main/resources/platform_lib");
        return new LoadFirstClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void setVertxMods() throws Exception {
        String vertxMods = System.getenv("VERTX_MODS");
        if (vertxMods != null) {
            this.modsDir = new File(vertxMods);
        }
        System.setProperty("vertx.mods", this.modsDir.getCanonicalPath());
    }

    private void addURLs(List<URL> urls, String dirName) throws IOException {
        File dir = new File(dirName);
        if (dir.exists()) {
            urls.add(dir.getCanonicalFile().toURI().toURL());
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String path = file.getCanonicalPath();
                    if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                    urls.add(file.getCanonicalFile().toURI().toURL());
                }
            }
        }
    }

    private static class LoadFirstClassLoader
    extends URLClassLoader {
        private final ClassLoader parent;

        private LoadFirstClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.parent = parent;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try {
                c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                return this.parent.loadClass(name);
            }
        }
    }
}

