/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="fatJar", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxFatJarMojo
extends BaseVertxMojo {
    @Parameter(property="vertx.createFatJar", defaultValue="false")
    protected Boolean createFatJar;

    public void execute() throws MojoExecutionException {
        try {
            if (this.createFatJar.booleanValue()) {
                System.setProperty("vertx.mods", this.modsDir.getAbsolutePath());
                PlatformManager pm = PlatformLocator.factory.createPlatformManager();
                final CountDownLatch latch = new CountDownLatch(1);
                pm.makeFatJar(this.moduleName, this.project.getBasedir().getAbsolutePath() + "/target", (Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> event) {
                        if (event.succeeded()) {
                            latch.countDown();
                        } else {
                            if (!event.succeeded()) {
                                VertxFatJarMojo.this.getLog().error(event.cause());
                            }
                            latch.countDown();
                        }
                    }
                });
                latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

