/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="init", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxInitMojo
extends BaseVertxMojo {
    public void execute() throws MojoExecutionException {
        try {
            this.setVertxMods();
            File cpFile = new File("vertx_classpath.txt");
            if (!cpFile.exists()) {
                cpFile.createNewFile();
                String defaultCp = "src/main/resources\r\ntarget/classes\r\ntarget/dependencies\r\nbin\r\n";
                try (FileWriter writer = new FileWriter(cpFile);){
                    writer.write(defaultCp);
                }
            }
            PlatformManager pm = PlatformLocator.factory.createPlatformManager();
            final CountDownLatch latch = new CountDownLatch(1);
            pm.createModuleLink(this.moduleName, (Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> asyncResult) {
                    if (!asyncResult.succeeded()) {
                        VertxInitMojo.this.getLog().info((CharSequence)asyncResult.cause().getMessage());
                    }
                    latch.countDown();
                }
            });
            latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

