/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="pullInDeps", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxPullInDepsMojo
extends BaseVertxMojo {
    @Parameter(property="vertx.pullInDeps", defaultValue="false")
    protected Boolean pullInDeps;

    public void execute() throws MojoExecutionException {
        if (this.pullInDeps.booleanValue()) {
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                this.setVertxMods();
                Thread.currentThread().setContextClassLoader(this.createClassLoader());
                PlatformManager pm = PlatformLocator.factory.createPlatformManager();
                final CountDownLatch latch = new CountDownLatch(1);
                pm.pullInDependencies(this.moduleName, (Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> event) {
                        if (!event.succeeded()) {
                            VertxPullInDepsMojo.this.getLog().error(event.cause());
                        }
                        latch.countDown();
                    }
                });
                latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
    }
}

