/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.maven.plugin.mojo;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.PlatformManager;
import org.vertx.maven.plugin.mojo.BaseVertxMojo;

@Mojo(name="runMod", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VertxRunModMojo
extends BaseVertxMojo {
    public void execute() throws MojoExecutionException {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setVertxMods();
            Thread.currentThread().setContextClassLoader(this.createClassLoader());
            final CountDownLatch latch = new CountDownLatch(1);
            final PlatformManager pm = this.createPlatformManager();
            pm.createModuleLink(this.moduleName, (Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> asyncResult) {
                    pm.deployModule(VertxRunModMojo.this.moduleName, VertxRunModMojo.this.getConf(), VertxRunModMojo.this.instances.intValue(), (Handler)new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> event) {
                            if (event.succeeded()) {
                                VertxRunModMojo.this.getLog().info((CharSequence)"CTRL-C to stop server");
                            } else {
                                if (!event.succeeded()) {
                                    VertxRunModMojo.this.getLog().error(event.cause());
                                }
                                latch.countDown();
                            }
                        }
                    });
                }
            });
            latch.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }
}

