/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ResolutionOptions {
    private boolean withTransitive = true;
    private List<String> exclusions = new ArrayList<String>();

    public boolean isWithTransitive() {
        return this.withTransitive;
    }

    public ResolutionOptions setWithTransitive(boolean withTransitive) {
        this.withTransitive = withTransitive;
        return this;
    }

    public ResolutionOptions addExclusion(String exclusion) {
        this.exclusions.add(exclusion);
        return this;
    }

    public ResolutionOptions removeExclusion(String exclusion) {
        this.exclusions.remove(exclusion);
        return this;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionOptions that = (ResolutionOptions)o;
        if (this.isWithTransitive() != that.isWithTransitive()) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>();
        set1.addAll(that.getExclusions());
        HashSet<String> set2 = new HashSet<String>();
        set2.addAll(this.getExclusions());
        return set1.equals(set2);
    }

    public int hashCode() {
        int result = this.isWithTransitive() ? 1 : 0;
        result = 31 * result + this.getExclusions().hashCode();
        return result;
    }
}

