/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.maven.MavenCoords;
import io.vertx.maven.Resolver;
import io.vertx.maven.ResolverOptions;
import io.vertx.maven.resolver.ResolutionOptions;
import io.vertx.service.ServiceVerticleFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;

public class MavenVerticleFactory
extends ServiceVerticleFactory {
    public static final String LOCAL_REPO_SYS_PROP = "vertx.maven.localRepo";
    public static final String REMOTE_REPOS_SYS_PROP = "vertx.maven.remoteRepos";
    public static final String HTTP_PROXY_SYS_PROP = "vertx.maven.httpProxy";
    public static final String HTTPS_PROXY_SYS_PROP = "vertx.maven.httpsProxy";
    public static final String REMOTE_SNAPSHOT_POLICY_SYS_PROP = "vertx.maven.remoteSnapshotPolicy";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String DEFAULT_MAVEN_LOCAL = USER_HOME + FILE_SEP + ".m2" + FILE_SEP + "repository";
    private static final String DEFAULT_MAVEN_REMOTES = "https://repo.maven.apache.org/maven2/ https://oss.sonatype.org/content/repositories/snapshots/";
    private Vertx vertx;
    private final Resolver resolver;
    public static volatile boolean RESOLVE_CALLED;

    public MavenVerticleFactory() {
        this(new ResolverOptions().setHttpProxy(System.getProperty(HTTP_PROXY_SYS_PROP)).setHttpsProxy(System.getProperty(HTTPS_PROXY_SYS_PROP)).setLocalRepository(System.getProperty(LOCAL_REPO_SYS_PROP, DEFAULT_MAVEN_LOCAL)).setRemoteRepositories(Arrays.asList(System.getProperty(REMOTE_REPOS_SYS_PROP, DEFAULT_MAVEN_REMOTES).split(" "))));
    }

    public MavenVerticleFactory(ResolverOptions options) {
        this(Resolver.create(options));
    }

    public MavenVerticleFactory(Resolver resolver) {
        this.resolver = resolver;
    }

    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    public String prefix() {
        return "maven";
    }

    public void resolve(String identifier, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<String> resolution) {
        RESOLVE_CALLED = true;
        this.vertx.executeBlocking(fut -> {
            try {
                String serviceIdentifer;
                List<Artifact> artifacts;
                String coordsString;
                String identifierNoPrefix = VerticleFactory.removePrefix((String)identifier);
                String serviceName = null;
                int pos = identifierNoPrefix.lastIndexOf("::");
                if (pos != -1) {
                    coordsString = identifierNoPrefix.substring(0, pos);
                    serviceName = identifierNoPrefix.substring(pos + 2);
                } else {
                    coordsString = identifierNoPrefix;
                }
                MavenCoords coords = new MavenCoords(coordsString);
                if (coords.version() == null) {
                    throw new IllegalArgumentException("Invalid service identifier, missing version: " + coordsString);
                }
                try {
                    artifacts = this.resolver.resolve(coordsString, new ResolutionOptions());
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Cannot find module " + coordsString + ". Maybe repository URL is invalid?");
                }
                if (serviceName != null) {
                    serviceIdentifer = "service:" + serviceName;
                } else {
                    String value = null;
                    for (Artifact result : artifacts) {
                        File file;
                        JarFile jarFile;
                        Manifest manifest;
                        if (!result.getGroupId().equals(coords.owner()) || !result.getArtifactId().equals(coords.serviceName()) || (manifest = (jarFile = new JarFile(file = result.getFile())).getManifest()) == null) continue;
                        value = (String)manifest.getMainAttributes().get(new Attributes.Name("Main-Verticle"));
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("Invalid service identifier, missing service name: " + identifierNoPrefix);
                    }
                    serviceIdentifer = value;
                }
                List classpath = artifacts.stream().map(res -> res.getFile().getAbsolutePath()).collect(Collectors.toList());
                URL[] urls = new URL[classpath.size()];
                int index = 0;
                ArrayList<String> extraCP = new ArrayList<String>(urls.length);
                for (String pathElement : classpath) {
                    File file = new File(pathElement);
                    extraCP.add(file.getAbsolutePath());
                    try {
                        URL url = file.toURI().toURL();
                        urls[index++] = url;
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException(e);
                    }
                }
                fut.complete(() -> {
                    deploymentOptions.setExtraClasspath(extraCP);
                    deploymentOptions.setIsolationGroup("__vertx_maven_" + coordsString);
                    URLClassLoader urlc = new URLClassLoader(urls, classLoader);
                    super.resolve(serviceIdentifer, deploymentOptions, (ClassLoader)urlc, resolution);
                });
            }
            catch (Exception e) {
                fut.fail((Throwable)e);
            }
        }, ar -> {
            if (ar.succeeded()) {
                ((Runnable)ar.result()).run();
            } else {
                resolution.fail(ar.cause());
            }
        });
    }

    public Resolver getResolver() {
        return this.resolver;
    }
}

