/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ResolverOptions {
    public static final String LOCAL_REPO_SYS_PROP = "vertx.maven.localRepo";
    public static final String REMOTE_REPOS_SYS_PROP = "vertx.maven.remoteRepos";
    public static final String HTTP_PROXY_SYS_PROP = "vertx.maven.httpProxy";
    public static final String HTTPS_PROXY_SYS_PROP = "vertx.maven.httpsProxy";
    public static final String REMOTE_SNAPSHOT_POLICY_SYS_PROP = "vertx.maven.remoteSnapshotPolicy";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String DEFAULT_MAVEN_LOCAL = USER_HOME + FILE_SEP + ".m2" + FILE_SEP + "repository";
    private static final String DEFAULT_MAVEN_REMOTES = "http://central.maven.org/maven2/ https://s01.oss.sonatype.org/content/repositories/snapshots/";
    private static final String DEFAULT_REMOTE_SNAPSHOT_POLICY = "daily";
    private String localRepository = System.getProperty("vertx.maven.localRepo", DEFAULT_MAVEN_LOCAL);
    private List<String> remoteRepositories = new ArrayList<String>(Arrays.asList(System.getProperty("vertx.maven.remoteRepos", "http://central.maven.org/maven2/ https://s01.oss.sonatype.org/content/repositories/snapshots/").split(" ")));
    private String httpProxy = System.getProperty("vertx.maven.httpProxy");
    private String httpsProxy = System.getProperty("vertx.maven.httpsProxy");
    private String remoteSnapshotPolicy = System.getProperty("vertx.maven.remoteSnapshotPolicy", "daily");

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public ResolverOptions setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public ResolverOptions setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return this;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public ResolverOptions setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public List<String> getRemoteRepositories() {
        if (this.remoteRepositories == null || this.remoteRepositories.isEmpty()) {
            String remoteString = System.getProperty(REMOTE_REPOS_SYS_PROP, DEFAULT_MAVEN_REMOTES);
            this.remoteRepositories = Arrays.asList(remoteString.split(" "));
        }
        return this.remoteRepositories;
    }

    public ResolverOptions setRemoteRepositories(List<String> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
        return this;
    }

    public String getRemoteSnapshotPolicy() {
        return this.remoteSnapshotPolicy;
    }

    public ResolverOptions setRemoteSnapshotPolicy(String remoteSnapshotPolicy) {
        this.remoteSnapshotPolicy = remoteSnapshotPolicy;
        return this;
    }
}

