/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.backends;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.micrometer.VertxPrometheusOptions;
import io.vertx.micrometer.backends.BackendRegistry;

public final class PrometheusBackendRegistry
implements BackendRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusBackendRegistry.class);
    private final PrometheusMeterRegistry registry;
    private final Vertx vertx;
    private final VertxPrometheusOptions options;
    private HttpServer server;

    public PrometheusBackendRegistry(Vertx vertx, VertxPrometheusOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.registry;
    }

    @Override
    public void eventBusInitialized(EventBus bus) {
        if (this.options.isStartEmbeddedServer()) {
            HttpServerOptions serverOptions = this.options.getEmbeddedServerOptions();
            if (serverOptions == null) {
                serverOptions = new HttpServerOptions();
            }
            Router router = Router.router((Vertx)this.vertx);
            router.route(this.options.getEmbeddedServerEndpoint()).handler(routingContext -> {
                String response = this.registry.scrape();
                routingContext.response().end(response);
            });
            this.server = this.vertx.createHttpServer(serverOptions).requestHandler(arg_0 -> ((Router)router).accept(arg_0)).exceptionHandler(t -> LOGGER.error((Object)"Error in Prometheus registry embedded server", t)).listen(serverOptions.getPort(), serverOptions.getHost());
        }
    }

    @Override
    public void close() {
        if (this.server != null) {
            this.server.close();
        }
    }
}

