/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.micrometer.Match;
import io.vertx.micrometer.MatchType;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MicrometerMetricsOptionsConverter;
import io.vertx.micrometer.VertxInfluxDbOptions;
import io.vertx.micrometer.VertxJmxMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@DataObject(generateConverter=true, inheritConverter=true)
public class MicrometerMetricsOptions
extends MetricsOptions {
    public static final String DEFAULT_REGISTRY_NAME = "default";
    public static final Match DEFAULT_HTTP_SERVER_MATCH = new Match().setDomain(MetricsDomain.HTTP_SERVER).setLabel("remote").setType(MatchType.REGEX).setValue(".*").setAlias("_");
    public static final Match DEFAULT_NET_SERVER_MATCH = new Match().setDomain(MetricsDomain.NET_SERVER).setLabel("remote").setType(MatchType.REGEX).setValue(".*").setAlias("_");
    public static final List<Match> DEFAULT_LABEL_MATCHES = Arrays.asList(DEFAULT_HTTP_SERVER_MATCH, DEFAULT_NET_SERVER_MATCH);
    private Set<MetricsDomain> disabledMetricsCategories;
    private String registryName;
    private List<Match> labelMatchs;
    private VertxInfluxDbOptions influxDbOptions;
    private VertxPrometheusOptions prometheusOptions;
    private VertxJmxMetricsOptions jmxMetricsOptions;

    public MicrometerMetricsOptions() {
        this.disabledMetricsCategories = EnumSet.noneOf(MetricsDomain.class);
        this.registryName = DEFAULT_REGISTRY_NAME;
        this.labelMatchs = new ArrayList<Match>(DEFAULT_LABEL_MATCHES);
    }

    public MicrometerMetricsOptions(MicrometerMetricsOptions other) {
        super((MetricsOptions)other);
        this.disabledMetricsCategories = other.disabledMetricsCategories != null ? EnumSet.copyOf(other.disabledMetricsCategories) : EnumSet.noneOf(MetricsDomain.class);
        this.registryName = other.registryName;
        this.labelMatchs = new ArrayList<Match>(other.labelMatchs);
        if (other.influxDbOptions != null) {
            this.influxDbOptions = new VertxInfluxDbOptions(other.influxDbOptions);
        }
        if (other.prometheusOptions != null) {
            this.prometheusOptions = new VertxPrometheusOptions(other.prometheusOptions);
        }
        if (other.jmxMetricsOptions != null) {
            this.jmxMetricsOptions = new VertxJmxMetricsOptions(other.jmxMetricsOptions);
        }
    }

    public MicrometerMetricsOptions(JsonObject json) {
        this();
        MicrometerMetricsOptionsConverter.fromJson(json, this);
        this.labelMatchs = this.loadLabelMatches(json);
    }

    private List<Match> loadLabelMatches(JsonObject json) {
        ArrayList<Match> list = new ArrayList<Match>();
        JsonArray monitored = json.getJsonArray("labelMatchs", new JsonArray());
        monitored.forEach(object -> {
            if (object instanceof JsonObject) {
                list.add(new Match((JsonObject)object));
            }
        });
        return list;
    }

    public MicrometerMetricsOptions setEnabled(boolean enable) {
        super.setEnabled(enable);
        return this;
    }

    public Set<MetricsDomain> getDisabledMetricsCategories() {
        return this.disabledMetricsCategories;
    }

    public MicrometerMetricsOptions setDisabledMetricsCategories(Set<MetricsDomain> disabledMetricsCategories) {
        this.disabledMetricsCategories = disabledMetricsCategories;
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addDisabledMetricsCategory(MetricsDomain metricsDomain) {
        if (this.disabledMetricsCategories == null) {
            this.disabledMetricsCategories = EnumSet.noneOf(MetricsDomain.class);
        }
        this.disabledMetricsCategories.add(metricsDomain);
        return this;
    }

    @GenIgnore
    public boolean isMetricsCategoryDisabled(MetricsDomain metricsDomain) {
        return this.disabledMetricsCategories != null && this.disabledMetricsCategories.contains((Object)metricsDomain);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public MicrometerMetricsOptions setRegistryName(String registryName) {
        this.registryName = registryName;
        return this;
    }

    public List<Match> getLabelMatchs() {
        return this.labelMatchs;
    }

    public MicrometerMetricsOptions setLabelMatchs(List<Match> matches) {
        this.labelMatchs = new ArrayList<Match>(matches);
        return this;
    }

    public MicrometerMetricsOptions addLabelMatch(Match match) {
        this.labelMatchs.add(match);
        return this;
    }

    public VertxInfluxDbOptions getInfluxDbOptions() {
        return this.influxDbOptions;
    }

    public MicrometerMetricsOptions setInfluxDbOptions(VertxInfluxDbOptions influxDbOptions) {
        this.influxDbOptions = influxDbOptions;
        return this;
    }

    public VertxPrometheusOptions getPrometheusOptions() {
        return this.prometheusOptions;
    }

    public MicrometerMetricsOptions setPrometheusOptions(VertxPrometheusOptions prometheusOptions) {
        this.prometheusOptions = prometheusOptions;
        return this;
    }

    public VertxJmxMetricsOptions getJmxMetricsOptions() {
        return this.jmxMetricsOptions;
    }

    public MicrometerMetricsOptions setJmxMetricsOptions(VertxJmxMetricsOptions jmxMetricsOptions) {
        this.jmxMetricsOptions = jmxMetricsOptions;
        return this;
    }
}

