/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.Label;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public abstract class AbstractMetrics
implements MicrometerMetrics {
    protected final MeterRegistry registry;
    protected final MetricsDomain domain;

    AbstractMetrics(MeterRegistry registry, MetricsDomain domain) {
        this.registry = registry;
        this.domain = domain;
    }

    @Override
    public MeterRegistry registry() {
        return this.registry;
    }

    @Override
    public String baseName() {
        return this.domain == null ? null : this.domain.getPrefix();
    }

    Counters counters(String name, String description, Label ... keys) {
        return new Counters(this.domain.getPrefix() + name, description, this.registry, keys);
    }

    Gauges<LongAdder> longGauges(String name, String description, Label ... keys) {
        return new Gauges<LongAdder>(this.domain.getPrefix() + name, description, LongAdder::new, LongAdder::doubleValue, this.registry, keys);
    }

    Gauges<AtomicReference<Double>> doubleGauges(String name, String description, Label ... keys) {
        return new Gauges<AtomicReference<Double>>(this.domain.getPrefix() + name, description, () -> new AtomicReference<Double>(0.0), AtomicReference::get, this.registry, keys);
    }

    Summaries summaries(String name, String description, Label ... keys) {
        return new Summaries(this.domain.getPrefix() + name, description, this.registry, keys);
    }

    Timers timers(String name, String description, Label ... keys) {
        return new Timers(this.domain.getPrefix() + name, description, this.registry, keys);
    }
}

