/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.VertxPrometheusOptionsConverter;

@DataObject(generateConverter=true, inheritConverter=true)
public class VertxPrometheusOptions {
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_START_EMBEDDED_SERVER = false;
    public static final String DEFAULT_EMBEDDED_SERVER_ENDPOINT = "/metrics";
    private boolean enabled;
    private boolean startEmbeddedServer;
    private HttpServerOptions embeddedServerOptions;
    private String embeddedServerEndpoint;

    public VertxPrometheusOptions() {
        this.enabled = false;
        this.startEmbeddedServer = false;
        this.embeddedServerEndpoint = DEFAULT_EMBEDDED_SERVER_ENDPOINT;
    }

    public VertxPrometheusOptions(VertxPrometheusOptions other) {
        this.enabled = other.enabled;
        this.startEmbeddedServer = other.startEmbeddedServer;
        String string = this.embeddedServerEndpoint = other.embeddedServerEndpoint != null ? other.embeddedServerEndpoint : DEFAULT_EMBEDDED_SERVER_ENDPOINT;
        if (other.embeddedServerOptions != null) {
            this.embeddedServerOptions = new HttpServerOptions(other.embeddedServerOptions);
        }
    }

    public VertxPrometheusOptions(JsonObject json) {
        this();
        VertxPrometheusOptionsConverter.fromJson(json, this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public VertxPrometheusOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isStartEmbeddedServer() {
        return this.startEmbeddedServer;
    }

    public VertxPrometheusOptions setStartEmbeddedServer(boolean startEmbeddedServer) {
        this.startEmbeddedServer = startEmbeddedServer;
        return this;
    }

    public HttpServerOptions getEmbeddedServerOptions() {
        return this.embeddedServerOptions;
    }

    public VertxPrometheusOptions setEmbeddedServerOptions(HttpServerOptions embeddedServerOptions) {
        this.embeddedServerOptions = embeddedServerOptions;
        return this;
    }

    public VertxPrometheusOptions setEmbeddedServerEndpoint(String embeddedServerEndpoint) {
        this.embeddedServerEndpoint = embeddedServerEndpoint;
        return this;
    }

    public String getEmbeddedServerEndpoint() {
        return this.embeddedServerEndpoint;
    }
}

