/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.Label;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.LongAdder;

class VertxHttpClientMetrics
extends VertxNetClientMetrics {
    private final Gauges<LongAdder> requests = this.longGauges("requests", "Number of requests waiting for a response", Label.LOCAL, Label.REMOTE, Label.PATH);
    private final Counters requestCount = this.counters("requestCount", "Number of requests sent", Label.LOCAL, Label.REMOTE, Label.PATH, Label.METHOD);
    private final Timers responseTime = this.timers("responseTime", "Response time", Label.LOCAL, Label.REMOTE, Label.PATH);
    private final Counters responseCount = this.counters("responseCount", "Response count with codes", Label.LOCAL, Label.REMOTE, Label.PATH, Label.CODE);
    private final Gauges<LongAdder> wsConnections = this.longGauges("wsConnections", "Number of websockets currently opened", Label.LOCAL, Label.REMOTE);

    VertxHttpClientMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.HTTP_CLIENT);
    }

    HttpClientMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    public static class Handler {
        private final String address;
        private final String path;
        private Timers.EventTiming timer;

        Handler(String address, String path) {
            this.address = address;
            this.path = path;
        }
    }

    class Instance
    extends VertxNetClientMetrics.Instance
    implements HttpClientMetrics<Handler, String, String, Void, Void> {
        Instance(String localAddress) {
            super(localAddress);
        }

        public Void createEndpoint(String host, int port, int maxPoolSize) {
            return null;
        }

        public void closeEndpoint(String host, int port, Void endpointMetric) {
        }

        public Void enqueueRequest(Void endpointMetric) {
            return null;
        }

        public void dequeueRequest(Void endpointMetric, Void taskMetric) {
        }

        public void endpointConnected(Void endpointMetric, String socketMetric) {
        }

        public void endpointDisconnected(Void endpointMetric, String socketMetric) {
        }

        public Handler requestBegin(Void endpointMetric, String remote, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
            Handler handler = new Handler(remote, request.path());
            ((LongAdder)VertxHttpClientMetrics.this.requests.get(this.local, remote, handler.path)).increment();
            VertxHttpClientMetrics.this.requestCount.get(this.local, remote, handler.path, request.method().name()).increment();
            handler.timer = VertxHttpClientMetrics.this.responseTime.start(this.local, remote, handler.path);
            return handler;
        }

        public void requestEnd(Handler requestMetric) {
        }

        public void responseBegin(Handler requestMetric, HttpClientResponse response) {
        }

        public Handler responsePushed(Void endpointMetric, String remote, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
            return this.requestBegin(null, remote, localAddress, remoteAddress, request);
        }

        public void requestReset(Handler handler) {
            ((LongAdder)VertxHttpClientMetrics.this.requests.get(this.local, handler.address, handler.path)).decrement();
        }

        public void responseEnd(Handler handler, HttpClientResponse response) {
            ((LongAdder)VertxHttpClientMetrics.this.requests.get(this.local, handler.address, handler.path)).decrement();
            VertxHttpClientMetrics.this.responseCount.get(this.local, handler.address, handler.path, String.valueOf(response.statusCode())).increment();
            handler.timer.end();
        }

        public String connected(Void endpointMetric, String remote, WebSocket webSocket) {
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote) {
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).decrement();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

