/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class Gauges<T> {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final Supplier<T> tSupplier;
    private final ToDoubleFunction<T> dGetter;
    private final MeterRegistry registry;
    private final Map<Meter.Id, T> gauges = new ConcurrentHashMap<Meter.Id, T>();

    public Gauges(String name, String description, Supplier<T> tSupplier, ToDoubleFunction<T> dGetter, MeterRegistry registry, Label ... keys) {
        this.name = name;
        this.description = description;
        this.tSupplier = tSupplier;
        this.dGetter = dGetter;
        this.registry = registry;
        this.keys = keys;
    }

    public synchronized T get(String ... values) {
        Object t = this.tSupplier.get();
        Gauge g = Gauge.builder((String)this.name, t, this.dGetter).description(this.description).tags(Labels.toTags(this.keys, values)).register(this.registry);
        return (T)this.gauges.computeIfAbsent(g.getId(), v -> t);
    }
}

