/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

class VertxPoolMetrics
extends AbstractMetrics {
    private final Timers queueDelay = this.timers("queue.delay", "Queue time for a resource", Label.POOL_TYPE, Label.POOL_NAME);
    private final Gauges<LongAdder> queueSize = this.longGauges("queue.size", "Number of elements waiting for a resource", Label.POOL_TYPE, Label.POOL_NAME);
    private final Timers usage = this.timers("usage", "Time using a resource", Label.POOL_TYPE, Label.POOL_NAME);
    private final Gauges<LongAdder> inUse = this.longGauges("inUse", "Number of resources used", Label.POOL_TYPE, Label.POOL_NAME);
    private final Gauges<AtomicReference<Double>> usageRatio = this.doubleGauges("ratio", "Pool usage ratio, only present if maximum pool size could be determined", Label.POOL_TYPE, Label.POOL_NAME);
    private final Counters completed = this.counters("completed", "Number of elements done with the resource", Label.POOL_TYPE, Label.POOL_NAME);

    VertxPoolMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.NAMED_POOLS);
    }

    PoolMetrics forInstance(String poolType, String poolName, int maxPoolSize) {
        return new Instance(poolType, poolName, maxPoolSize);
    }

    class Instance
    implements MicrometerMetrics,
    PoolMetrics<Timers.EventTiming> {
        private final String poolType;
        private final String poolName;
        private final int maxPoolSize;

        Instance(String poolType, String poolName, int maxPoolSize) {
            this.poolType = poolType;
            this.poolName = poolName;
            this.maxPoolSize = maxPoolSize;
        }

        public Timers.EventTiming submitted() {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).increment();
            return VertxPoolMetrics.this.queueDelay.start();
        }

        public void rejected(Timers.EventTiming submitted) {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).decrement();
            submitted.end(this.poolType, this.poolName);
        }

        public Timers.EventTiming begin(Timers.EventTiming submitted) {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).decrement();
            submitted.end(this.poolType, this.poolName);
            LongAdder l = (LongAdder)VertxPoolMetrics.this.inUse.get(this.poolType, this.poolName);
            l.increment();
            this.checkRatio(l.longValue());
            return VertxPoolMetrics.this.usage.start();
        }

        public void end(Timers.EventTiming begin, boolean succeeded) {
            LongAdder l = (LongAdder)VertxPoolMetrics.this.inUse.get(this.poolType, this.poolName);
            l.decrement();
            this.checkRatio(l.longValue());
            begin.end(this.poolType, this.poolName);
            VertxPoolMetrics.this.completed.get(this.poolType, this.poolName).increment();
        }

        public boolean isEnabled() {
            return true;
        }

        public void close() {
        }

        private void checkRatio(long inUse) {
            if (this.maxPoolSize > 0) {
                ((AtomicReference)VertxPoolMetrics.this.usageRatio.get(this.poolType, this.poolName)).set((double)inUse / (double)this.maxPoolSize);
            }
        }

        @Override
        public MeterRegistry registry() {
            return VertxPoolMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxPoolMetrics.this.domain.getPrefix();
        }
    }
}

