/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Verticle;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.meters.Gauges;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

class VertxVerticleMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> deployed = this.longGauges("deployed", "Number of verticle instances deployed", Label.CLASS_NAME);

    VertxVerticleMetrics(MeterRegistry registry, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, MetricsDomain.VERTICLES, gaugesTable);
    }

    void verticleDeployed(Verticle verticle) {
        this.deployed.get(verticle.getClass().getName()).increment();
    }

    void verticleUndeployed(Verticle verticle) {
        this.deployed.get(verticle.getClass().getName()).decrement();
    }
}

