/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.LongAdder;

class VertxEventBusMetrics
extends AbstractMetrics
implements EventBusMetrics<Handler> {
    private static final Handler IGNORED = new Handler(null);
    private final Gauges<LongAdder> handlers = this.longGauges("handlers", "Number of event bus handlers in use", Label.EB_ADDRESS);
    private final Gauges<LongAdder> pending = this.longGauges("pending", "Number of messages not processed yet", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters published = this.counters("published", "Number of messages published (publish / subscribe)", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters sent = this.counters("sent", "Number of messages sent (point-to-point)", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters received = this.counters("received", "Number of messages received", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters delivered = this.counters("delivered", "Number of messages delivered to handlers", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters discarded = this.counters("discarded", "Number of discarded messages", Label.EB_ADDRESS, Label.EB_SIDE);
    private final Counters errorCount = this.counters("errors", "Number of errors", Label.EB_ADDRESS, Label.CLASS_NAME);
    private final Counters replyFailures = this.counters("replyFailures", "Number of message reply failures", Label.EB_ADDRESS, Label.EB_FAILURE);
    private final Timers processTime = this.timers("processingTime", "Processing time", Label.EB_ADDRESS);
    private final Summaries bytesRead = this.summaries("bytesRead", "Number of bytes received while reading messages from event bus cluster peers", Label.EB_ADDRESS);
    private final Summaries bytesWritten = this.summaries("bytesWritten", "Number of bytes sent while sending messages to event bus cluster peers", Label.EB_ADDRESS);

    VertxEventBusMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.EVENT_BUS);
    }

    private static boolean isInternal(String address) {
        return address.startsWith("__vertx.");
    }

    public Handler handlerRegistered(String address, String repliedAddress) {
        if (VertxEventBusMetrics.isInternal(address)) {
            return IGNORED;
        }
        this.handlers.get(address).increment();
        return new Handler(address);
    }

    public void handlerUnregistered(Handler handler) {
        if (VertxEventBusMetrics.isValid(handler)) {
            this.handlers.get(handler.address).decrement();
        }
    }

    public void scheduleMessage(Handler handler, boolean b) {
    }

    public void beginHandleMessage(Handler handler, boolean local) {
        if (VertxEventBusMetrics.isValid(handler)) {
            this.pending.get(handler.address, Labels.getSide(local)).decrement();
            handler.timer = this.processTime.start();
        }
    }

    public void endHandleMessage(Handler handler, Throwable failure) {
        if (VertxEventBusMetrics.isValid(handler)) {
            handler.timer.end(handler.address);
            if (failure != null) {
                this.errorCount.get(handler.address, failure.getClass().getSimpleName()).increment();
            }
        }
    }

    public void discardMessage(Handler handler, boolean local, Message<?> msg) {
        if (VertxEventBusMetrics.isValid(handler)) {
            this.pending.get(handler.address, Labels.getSide(local)).decrement();
            this.discarded.get(handler.address, Labels.getSide(local)).increment();
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            if (publish) {
                this.published.get(address, Labels.getSide(local)).increment();
            } else {
                this.sent.get(address, Labels.getSide(local)).increment();
            }
        }
    }

    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            String origin = Labels.getSide(local);
            this.pending.get(address, origin).add(handlers);
            this.received.get(address, origin).increment();
            if (handlers > 0) {
                this.delivered.get(address, origin).increment();
            }
        }
    }

    public void messageWritten(String address, int numberOfBytes) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            this.bytesWritten.get(address).record((double)numberOfBytes);
        }
    }

    public void messageRead(String address, int numberOfBytes) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            this.bytesRead.get(address).record((double)numberOfBytes);
        }
    }

    public void replyFailure(String address, ReplyFailure failure) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            this.replyFailures.get(address, failure.name()).increment();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void close() {
    }

    private static boolean isValid(Handler handler) {
        return handler != null && handler.address != null;
    }

    static class Handler {
        private final String address;
        private Timers.EventTiming timer;

        Handler(String address) {
            this.address = address;
        }
    }
}

