/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.VertxNetServerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.LongAdder;

class VertxHttpServerMetrics
extends VertxNetServerMetrics {
    private final Gauges<LongAdder> requests = this.longGauges("requests", "Number of requests being processed", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
    private final Counters requestCount = this.counters("requestCount", "Number of processed requests", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
    private final Counters requestResetCount = this.counters("requestResetCount", "Number of requests reset", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
    private final Timers processingTime = this.timers("responseTime", "Request processing time", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
    private final Gauges<LongAdder> wsConnections = this.longGauges("wsConnections", "Number of websockets currently opened", Label.LOCAL, Label.REMOTE);

    VertxHttpServerMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.HTTP_SERVER);
    }

    HttpServerMetrics forAddress(SocketAddress localAddress) {
        String local = Labels.fromAddress(localAddress);
        return new Instance(local);
    }

    public static class Handler {
        private final String address;
        private final String path;
        private final String method;
        private Timers.EventTiming timer;

        Handler(String address, String path, String method) {
            this.address = address;
            this.path = path;
            this.method = method;
        }
    }

    class Instance
    extends VertxNetServerMetrics.Instance
    implements HttpServerMetrics<Handler, String, String> {
        Instance(String local) {
            super(VertxHttpServerMetrics.this, local);
        }

        public Handler requestBegin(String remote, HttpServerRequest request) {
            Handler handler = new Handler(remote, request.path(), request.method().name());
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(this.local, remote, handler.path, handler.method)).increment();
            handler.timer = VertxHttpServerMetrics.this.processingTime.start();
            return handler;
        }

        public void requestReset(Handler handler) {
            VertxHttpServerMetrics.this.requestResetCount.get(this.local, handler.address, handler.path, handler.method).increment();
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(this.local, handler.address, handler.path, handler.method)).decrement();
        }

        public Handler responsePushed(String remote, HttpMethod method, String uri, HttpServerResponse response) {
            Handler handler = new Handler(remote, uri, method.name());
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(this.local, remote, handler.path, handler.method)).increment();
            return handler;
        }

        public void responseEnd(Handler handler, HttpServerResponse response) {
            String code = String.valueOf(response.getStatusCode());
            handler.timer.end(this.local, handler.address, handler.path, handler.method, code);
            VertxHttpServerMetrics.this.requestCount.get(this.local, handler.address, handler.path, handler.method, code).increment();
            ((LongAdder)VertxHttpServerMetrics.this.requests.get(this.local, handler.address, handler.path, handler.method)).decrement();
        }

        public String connected(String socketMetric, Handler handler, ServerWebSocket serverWebSocket) {
            ((LongAdder)VertxHttpServerMetrics.this.wsConnections.get(this.local, handler.address)).increment();
            return handler.address;
        }

        public void disconnected(String remote) {
            ((LongAdder)VertxHttpServerMetrics.this.wsConnections.get(this.local, remote)).decrement();
        }

        @Override
        public void close() {
        }
    }
}

