/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.LongAdder;

class VertxClientMetrics
extends AbstractMetrics {
    private final Timers queueDelay = this.timers("queue.time", "Time spent in queue before being processed", Label.REMOTE, Label.NAMESPACE);
    private final Gauges<LongAdder> queueSize = this.longGauges("queue.pending", "Number of pending elements in queue", Label.REMOTE, Label.NAMESPACE);
    private final Timers processingTime = this.timers("processing.time", "Processing time, from request start to response end", Label.REMOTE, Label.NAMESPACE);
    private final Gauges<LongAdder> processingPending = this.longGauges("processing.pending", "Number of elements being processed", Label.REMOTE, Label.NAMESPACE);
    private final Counters resetCount = this.counters("reset", "Total number of requests reset", Label.REMOTE, Label.NAMESPACE);

    VertxClientMetrics(MeterRegistry registry, String type) {
        super(registry, type);
    }

    ClientMetrics forInstance(SocketAddress remoteAddress, String namespace) {
        return new Instance(remoteAddress, namespace);
    }

    class Instance
    implements ClientMetrics<Timers.EventTiming, Timers.EventTiming, Object, Object> {
        private final String remote;
        private final String namespace;

        Instance(SocketAddress remoteAddress, String namespace) {
            this.remote = remoteAddress == null ? "" : remoteAddress.toString();
            this.namespace = namespace == null ? "" : namespace;
        }

        public Timers.EventTiming enqueueRequest() {
            ((LongAdder)VertxClientMetrics.this.queueSize.get(this.remote, this.namespace)).increment();
            return VertxClientMetrics.this.queueDelay.start();
        }

        public void dequeueRequest(Timers.EventTiming taskMetric) {
            ((LongAdder)VertxClientMetrics.this.queueSize.get(this.remote, this.namespace)).decrement();
            taskMetric.end(this.remote, this.namespace);
        }

        public Timers.EventTiming requestBegin(String uri, Object request) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).increment();
            return VertxClientMetrics.this.processingTime.start();
        }

        public void requestEnd(Timers.EventTiming requestMetric) {
        }

        public void responseBegin(Timers.EventTiming requestMetric, Object response) {
        }

        public void requestReset(Timers.EventTiming requestMetric) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).decrement();
            requestMetric.end(this.remote, this.namespace);
            VertxClientMetrics.this.resetCount.get(this.remote, this.namespace).increment();
        }

        public void responseEnd(Timers.EventTiming requestMetric) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).decrement();
            requestMetric.end(this.remote, this.namespace);
        }

        public void close() {
        }
    }
}

