/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.LongAdder;

class VertxHttpClientMetrics
extends VertxNetClientMetrics {
    private final Timers queueDelay = this.timers("queue.delay", "Time spent in queue before being processed", Label.LOCAL, Label.REMOTE);
    private final Gauges<LongAdder> queueSize = this.longGauges("queue.size", "Number of pending elements in queue", Label.LOCAL, Label.REMOTE);
    private final Gauges<LongAdder> requests = this.longGauges("requests", "Number of requests waiting for a response", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
    private final Counters requestCount = this.counters("requestCount", "Number of requests sent", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
    private final Timers responseTime = this.timers("responseTime", "Response time", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
    private final Counters responseCount = this.counters("responseCount", "Response count with codes", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
    private final Gauges<LongAdder> wsConnections = this.longGauges("wsConnections", "Number of websockets currently opened", Label.LOCAL, Label.REMOTE);

    VertxHttpClientMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.HTTP_CLIENT);
    }

    HttpClientMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    public static class Handler {
        private final String address;
        private final String path;
        private final String method;
        private Timers.EventTiming timer;
        HttpResponse response;

        Handler(String address, String path, String method) {
            this.address = address;
            this.path = path;
            this.method = method;
        }
    }

    class Instance
    extends VertxNetClientMetrics.Instance
    implements HttpClientMetrics<Handler, String, String, Timers.EventTiming> {
        Instance(String localAddress) {
            super(localAddress);
        }

        public ClientMetrics<Handler, Timers.EventTiming, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
            final String remote = remoteAddress.toString();
            return new ClientMetrics<Handler, Timers.EventTiming, HttpRequest, HttpResponse>(){

                public Timers.EventTiming enqueueRequest() {
                    ((LongAdder)VertxHttpClientMetrics.this.queueSize.get(Instance.this.local, remote)).increment();
                    return VertxHttpClientMetrics.this.queueDelay.start();
                }

                public void dequeueRequest(Timers.EventTiming taskMetric) {
                    ((LongAdder)VertxHttpClientMetrics.this.queueSize.get(Instance.this.local, remote)).decrement();
                    taskMetric.end(Instance.this.local, remote);
                }

                public Handler requestBegin(String uri, HttpRequest request) {
                    Handler handler = new Handler(remote, request.uri(), request.method().name());
                    ((LongAdder)VertxHttpClientMetrics.this.requests.get(Instance.this.local, remote, handler.path, handler.method)).increment();
                    VertxHttpClientMetrics.this.requestCount.get(Instance.this.local, remote, handler.path, handler.method).increment();
                    handler.timer = VertxHttpClientMetrics.this.responseTime.start();
                    return handler;
                }

                public void responseBegin(Handler requestMetric, HttpResponse response) {
                    requestMetric.response = response;
                }

                public void requestReset(Handler handler) {
                    ((LongAdder)VertxHttpClientMetrics.this.requests.get(Instance.this.local, handler.address, handler.path, handler.method)).decrement();
                }

                public void responseEnd(Handler handler) {
                    String code = String.valueOf(handler.response.statusCode());
                    ((LongAdder)VertxHttpClientMetrics.this.requests.get(Instance.this.local, handler.address, handler.path, handler.method)).decrement();
                    VertxHttpClientMetrics.this.responseCount.get(Instance.this.local, handler.address, handler.path, handler.method, code).increment();
                    handler.timer.end(Instance.this.local, handler.address, handler.path, handler.method, code);
                }
            };
        }

        public String connected(WebSocket webSocket) {
            String remote = webSocket.remoteAddress().toString();
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote) {
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).decrement();
        }

        @Override
        public void close() {
        }
    }
}

