/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Summaries;

class VertxDatagramSocketMetrics
extends AbstractMetrics
implements DatagramSocketMetrics {
    private final Summaries bytesReceived = this.summaries("bytesReceived", "Total number of datagram bytes received", Label.LOCAL);
    private final Summaries bytesSent = this.summaries("bytesSent", "Total number of datagram bytes sent", new Label[0]);
    private final Counters errorCount = this.counters("errors", "Total number of datagram errors", Label.CLASS_NAME);
    private volatile String localAddress;

    VertxDatagramSocketMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.DATAGRAM_SOCKET);
    }

    public void listening(String localName, SocketAddress localAddress) {
        this.localAddress = Labels.address(localAddress, localName);
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (this.localAddress != null) {
            this.bytesReceived.get(this.localAddress).record((double)numberOfBytes);
        }
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesSent.get(new String[0]).record((double)numberOfBytes);
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errorCount.get(t.getClass().getSimpleName()).increment();
    }

    public void close() {
    }
}

