/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import java.util.concurrent.atomic.LongAdder;

class VertxNetClientMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> connections = this.longGauges("connections", "Number of connections to the remote host currently opened", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesReceived = this.summaries("bytesReceived", "Number of bytes received from the remote host", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesSent = this.summaries("bytesSent", "Number of bytes sent to the remote host", Label.LOCAL, Label.REMOTE);
    private final Counters errorCount = this.counters("errors", "Number of errors", Label.LOCAL, Label.REMOTE, Label.CLASS_NAME);

    VertxNetClientMetrics(MeterRegistry registry) {
        this(registry, MetricsDomain.NET_CLIENT);
    }

    VertxNetClientMetrics(MeterRegistry registry, MetricsDomain domain) {
        super(registry, domain);
    }

    TCPMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    class Instance
    implements MicrometerMetrics,
    TCPMetrics<String> {
        protected final String local;

        Instance(String localAddress) {
            this.local = localAddress == null ? "?" : localAddress;
        }

        public String connected(SocketAddress remoteAddress, String remoteName) {
            String remote = Labels.address(remoteAddress, remoteName);
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote, SocketAddress remoteAddress) {
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).decrement();
        }

        public void bytesRead(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesReceived.get(this.local, remote).record((double)numberOfBytes);
        }

        public void bytesWritten(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesSent.get(this.local, remote).record((double)numberOfBytes);
        }

        public void exceptionOccurred(String remote, SocketAddress remoteAddress, Throwable t) {
            VertxNetClientMetrics.this.errorCount.get(this.local, remote, t.getClass().getSimpleName()).increment();
        }

        public void close() {
        }

        @Override
        public MeterRegistry registry() {
            return VertxNetClientMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxNetClientMetrics.this.baseName();
        }
    }
}

