/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import java.util.concurrent.atomic.LongAdder;

class VertxNetServerMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> connections = this.longGauges("connections", "Number of opened connections to the server", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesReceived = this.summaries("bytesReceived", "Number of bytes received by the server", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesSent = this.summaries("bytesSent", "Number of bytes sent by the server", Label.LOCAL, Label.REMOTE);
    private final Counters errorCount = this.counters("errors", "Number of errors", Label.LOCAL, Label.REMOTE, Label.CLASS_NAME);

    VertxNetServerMetrics(MeterRegistry registry) {
        this(registry, MetricsDomain.NET_SERVER);
    }

    VertxNetServerMetrics(MeterRegistry registry, MetricsDomain domain) {
        super(registry, domain);
    }

    TCPMetrics forAddress(SocketAddress localAddress) {
        return new Instance(Labels.address(localAddress));
    }

    class Instance
    implements MicrometerMetrics,
    TCPMetrics<String> {
        final String local;

        Instance(String local) {
            this.local = local;
        }

        public String connected(SocketAddress remoteAddress, String remoteName) {
            String remote = Labels.address(remoteAddress, remoteName);
            ((LongAdder)VertxNetServerMetrics.this.connections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote, SocketAddress remoteAddress) {
            ((LongAdder)VertxNetServerMetrics.this.connections.get(this.local, remote)).decrement();
        }

        public void bytesRead(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetServerMetrics.this.bytesReceived.get(this.local, remote).record((double)numberOfBytes);
        }

        public void bytesWritten(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetServerMetrics.this.bytesSent.get(this.local, remote).record((double)numberOfBytes);
        }

        public void exceptionOccurred(String remote, SocketAddress remoteAddress, Throwable t) {
            VertxNetServerMetrics.this.errorCount.get(this.local, remote, t.getClass().getSimpleName()).increment();
        }

        public void close() {
        }

        @Override
        public MeterRegistry registry() {
            return VertxNetServerMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxNetServerMetrics.this.baseName();
        }
    }
}

