/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

class VertxPoolMetrics
extends AbstractMetrics {
    private final Timers queueDelay;
    private final Gauges<LongAdder> queueSize;
    private final Timers usage;
    private final Gauges<LongAdder> inUse;
    private final Gauges<AtomicReference<Double>> usageRatio;
    private final Counters completed;

    VertxPoolMetrics(MeterRegistry registry, MetricsNaming names) {
        super(registry, MetricsDomain.NAMED_POOLS);
        this.queueDelay = this.timers(names.getPoolQueueTime(), "Time spent in queue before being processed", Label.POOL_TYPE, Label.POOL_NAME);
        this.queueSize = this.longGauges(names.getPoolQueuePending(), "Number of pending elements in queue", Label.POOL_TYPE, Label.POOL_NAME);
        this.usage = this.timers(names.getPoolUsage(), "Time using a resource", Label.POOL_TYPE, Label.POOL_NAME);
        this.inUse = this.longGauges(names.getPoolInUse(), "Number of resources used", Label.POOL_TYPE, Label.POOL_NAME);
        this.usageRatio = this.doubleGauges(names.getPoolUsageRatio(), "Pool usage ratio, only present if maximum pool size could be determined", Label.POOL_TYPE, Label.POOL_NAME);
        this.completed = this.counters(names.getPoolCompleted(), "Number of elements done with the resource", Label.POOL_TYPE, Label.POOL_NAME);
    }

    PoolMetrics forInstance(String poolType, String poolName, int maxPoolSize) {
        return new Instance(poolType, poolName, maxPoolSize);
    }

    class Instance
    implements MicrometerMetrics,
    PoolMetrics<Timers.EventTiming> {
        private final String poolType;
        private final String poolName;
        private final int maxPoolSize;

        Instance(String poolType, String poolName, int maxPoolSize) {
            this.poolType = poolType;
            this.poolName = poolName;
            this.maxPoolSize = maxPoolSize;
        }

        public Timers.EventTiming submitted() {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).increment();
            return VertxPoolMetrics.this.queueDelay.start();
        }

        public void rejected(Timers.EventTiming submitted) {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).decrement();
            submitted.end(this.poolType, this.poolName);
        }

        public Timers.EventTiming begin(Timers.EventTiming submitted) {
            ((LongAdder)VertxPoolMetrics.this.queueSize.get(this.poolType, this.poolName)).decrement();
            submitted.end(this.poolType, this.poolName);
            LongAdder l = (LongAdder)VertxPoolMetrics.this.inUse.get(this.poolType, this.poolName);
            l.increment();
            this.checkRatio(l.longValue());
            return VertxPoolMetrics.this.usage.start();
        }

        public void end(Timers.EventTiming timer, boolean succeeded) {
            LongAdder l = (LongAdder)VertxPoolMetrics.this.inUse.get(this.poolType, this.poolName);
            l.decrement();
            this.checkRatio(l.longValue());
            timer.end(this.poolType, this.poolName);
            VertxPoolMetrics.this.completed.get(this.poolType, this.poolName).increment();
        }

        public void close() {
        }

        private void checkRatio(long inUse) {
            if (this.maxPoolSize > 0) {
                ((AtomicReference)VertxPoolMetrics.this.usageRatio.get(this.poolType, this.poolName)).set((double)inUse / (double)this.maxPoolSize);
            }
        }

        @Override
        public MeterRegistry registry() {
            return VertxPoolMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxPoolMetrics.this.baseName();
        }
    }
}

