/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.Match;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.VertxInfluxDbOptions;
import io.vertx.micrometer.VertxJmxMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MicrometerMetricsOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, MicrometerMetricsOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "disabledMetricsCategories": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setDisabledMetricsCategories(list);
                    break;
                }
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "influxDbOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setInfluxDbOptions(new VertxInfluxDbOptions((JsonObject)member.getValue()));
                    break;
                }
                case "jmxMetricsOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJmxMetricsOptions(new VertxJmxMetricsOptions((JsonObject)member.getValue()));
                    break;
                }
                case "jvmMetricsEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setJvmMetricsEnabled((Boolean)member.getValue());
                    break;
                }
                case "labelMatches": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((String)((Object)new Match((JsonObject)item)));
                        }
                    });
                    obj.setLabelMatches((List<Match>)((Object)list));
                    break;
                }
                case "labelMatchs": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addLabelMatch(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "labels": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Label.valueOf((String)item)));
                        }
                    });
                    obj.setLabels(list);
                    break;
                }
                case "metricsNaming": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setMetricsNaming(new MetricsNaming((JsonObject)member.getValue()));
                    break;
                }
                case "prometheusOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPrometheusOptions(new VertxPrometheusOptions((JsonObject)member.getValue()));
                    break;
                }
                case "registryName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRegistryName((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(MicrometerMetricsOptions obj, JsonObject json) {
        MicrometerMetricsOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(MicrometerMetricsOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getDisabledMetricsCategories() != null) {
            array = new JsonArray();
            obj.getDisabledMetricsCategories().forEach(item -> array.add(item));
            json.put("disabledMetricsCategories", array);
        }
        json.put("enabled", obj.isEnabled());
        if (obj.getInfluxDbOptions() != null) {
            json.put("influxDbOptions", obj.getInfluxDbOptions().toJson());
        }
        if (obj.getJmxMetricsOptions() != null) {
            json.put("jmxMetricsOptions", obj.getJmxMetricsOptions().toJson());
        }
        json.put("jvmMetricsEnabled", obj.isJvmMetricsEnabled());
        if (obj.getLabels() != null) {
            array = new JsonArray();
            obj.getLabels().forEach(item -> array.add((Object)item.name()));
            json.put("labels", array);
        }
        if (obj.getMetricsNaming() != null) {
            json.put("metricsNaming", obj.getMetricsNaming().toJson());
        }
        if (obj.getPrometheusOptions() != null) {
            json.put("prometheusOptions", obj.getPrometheusOptions().toJson());
        }
        if (obj.getRegistryName() != null) {
            json.put("registryName", obj.getRegistryName());
        }
    }
}

