/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Tag;
import io.vertx.core.net.SocketAddress;
import io.vertx.micrometer.Label;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Labels {
    private Labels() {
    }

    static String address(SocketAddress address) {
        return Labels.address(address, null);
    }

    static String address(SocketAddress address, String nameOverride) {
        if (address == null) {
            return "?";
        }
        if (nameOverride == null) {
            return address.toString();
        }
        SocketAddress addrOverride = address.port() >= 0 ? SocketAddress.inetSocketAddress((int)address.port(), (String)nameOverride) : SocketAddress.domainSocketAddress((String)nameOverride);
        return addrOverride.toString();
    }

    static String getSide(boolean local) {
        return local ? "local" : "remote";
    }

    public static List<Tag> toTags(Label[] keys, String[] values) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null) continue;
            String lowKey = keys[i].toString();
            tags.add(Tag.of((String)lowKey, (String)values[i]));
        }
        return tags;
    }
}

