/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Gauges<T> {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final Supplier<T> tSupplier;
    private final ToDoubleFunction<T> dGetter;
    private final MeterRegistry registry;
    private final Map<Meter.Id, T> gauges = new ConcurrentHashMap<Meter.Id, T>();

    public Gauges(String name, String description, Supplier<T> tSupplier, ToDoubleFunction<T> dGetter, MeterRegistry registry, Label ... keys) {
        this.name = name;
        this.description = description;
        this.tSupplier = tSupplier;
        this.dGetter = dGetter;
        this.registry = registry;
        this.keys = keys;
    }

    public T get(String ... values) {
        return this.get((Iterable<Tag>)null, values);
    }

    public synchronized T get(Iterable<Tag> customTags, String ... values) {
        List<Tag> tags = customTags != null ? Stream.concat(Labels.toTags(this.keys, values).stream(), StreamSupport.stream(customTags.spliterator(), false)).collect(Collectors.toList()) : Labels.toTags(this.keys, values);
        Object t = this.tSupplier.get();
        Gauge g = Gauge.builder((String)this.name, t, this.dGetter).description(this.description).tags(tags).register(this.registry);
        return (T)this.gauges.computeIfAbsent(g.getId(), v -> t);
    }
}

