/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.micrometer.backends.BackendRegistries;

public class PrometheusScrapingHandlerImpl
implements Handler<RoutingContext> {
    private final String registryName;

    public PrometheusScrapingHandlerImpl() {
        this.registryName = null;
    }

    public PrometheusScrapingHandlerImpl(String registryName) {
        this.registryName = registryName;
    }

    public void handle(RoutingContext rc) {
        MeterRegistry registry = this.registryName == null ? BackendRegistries.getDefaultNow() : BackendRegistries.getNow(this.registryName);
        if (registry instanceof PrometheusMeterRegistry) {
            PrometheusMeterRegistry prometheusMeterRegistry = (PrometheusMeterRegistry)registry;
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; version=0.0.4; charset=utf-8").end(prometheusMeterRegistry.scrape());
        } else {
            String statusMessage = "Invalid registry: " + (registry != null ? registry.getClass().getName() : null);
            rc.response().setStatusCode(500).setStatusMessage(statusMessage).end();
        }
    }
}

