/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class Gauges<T> {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final Supplier<T> tSupplier;
    private final ToDoubleFunction<T> dGetter;
    private final MeterRegistry registry;
    private final ConcurrentMap<Meter.Id, Object> gauges;

    public Gauges(ConcurrentMap<Meter.Id, Object> gauges, String name, String description, Supplier<T> tSupplier, ToDoubleFunction<T> dGetter, MeterRegistry registry, Label ... keys) {
        this.gauges = gauges;
        this.name = name;
        this.description = description;
        this.tSupplier = tSupplier;
        this.dGetter = dGetter;
        this.registry = registry;
        this.keys = keys;
    }

    public T get(String ... values) {
        return this.get((Iterable<Tag>)null, values);
    }

    public T get(Iterable<Tag> customTags, String ... values) {
        Object res;
        CompositeMeterRegistry cmr;
        Tags tags = Tags.of(Labels.toTags(this.keys, values)).and(customTags);
        T candidate = this.tSupplier.get();
        ToDoubleFunc<T> candidateFunc = new ToDoubleFunc<T>(this.dGetter);
        Gauge gauge = Gauge.builder((String)this.name, candidate, candidateFunc).description(this.description).tags((Iterable)tags).register(this.registry);
        SimpleMeterRegistry smr = null;
        if (this.registry instanceof CompositeMeterRegistry && (cmr = (CompositeMeterRegistry)this.registry).getRegistries().isEmpty()) {
            smr = new SimpleMeterRegistry();
            cmr.add((MeterRegistry)smr);
        }
        Meter.Id gaugeId = gauge.getId();
        while ((res = this.gauges.get(gaugeId)) == null) {
            this.ensureGetterInvoked(gauge);
            if (!candidateFunc.invoked) continue;
            this.gauges.put(gaugeId, candidate);
            res = candidate;
            break;
        }
        if (smr != null) {
            CompositeMeterRegistry cmr2 = (CompositeMeterRegistry)this.registry;
            cmr2.remove((MeterRegistry)smr);
        }
        return (T)res;
    }

    private void ensureGetterInvoked(Gauge gauge) {
        gauge.value();
    }

    private static class ToDoubleFunc<R>
    implements ToDoubleFunction<R> {
        final ToDoubleFunction<R> delegate;
        volatile boolean invoked;

        ToDoubleFunc(ToDoubleFunction<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public double applyAsDouble(R value) {
            if (!this.invoked) {
                this.invoked = true;
            }
            return this.delegate.applyAsDouble(value);
        }
    }
}

